/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class SalesforceMarketingCloudLinkedServiceTypeProperties
implements JsonSerializable<SalesforceMarketingCloudLinkedServiceTypeProperties> {
    private Object connectionProperties;
    private Object clientId;
    private SecretBase clientSecret;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private String encryptedCredential;

    public Object connectionProperties() {
        return this.connectionProperties;
    }

    public SalesforceMarketingCloudLinkedServiceTypeProperties withConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public SalesforceMarketingCloudLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public SalesforceMarketingCloudLinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public SalesforceMarketingCloudLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object useHostVerification() {
        return this.useHostVerification;
    }

    public SalesforceMarketingCloudLinkedServiceTypeProperties withUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object usePeerVerification() {
        return this.usePeerVerification;
    }

    public SalesforceMarketingCloudLinkedServiceTypeProperties withUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SalesforceMarketingCloudLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.connectionProperties != null) {
            jsonWriter.writeUntypedField("connectionProperties", this.connectionProperties);
        }
        if (this.clientId != null) {
            jsonWriter.writeUntypedField("clientId", this.clientId);
        }
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        if (this.useEncryptedEndpoints != null) {
            jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
        }
        if (this.useHostVerification != null) {
            jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
        }
        if (this.usePeerVerification != null) {
            jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SalesforceMarketingCloudLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceMarketingCloudLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SalesforceMarketingCloudLinkedServiceTypeProperties deserializedSalesforceMarketingCloudLinkedServiceTypeProperties = new SalesforceMarketingCloudLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionProperties".equals(fieldName)) {
                    deserializedSalesforceMarketingCloudLinkedServiceTypeProperties.connectionProperties = reader.readUntyped();
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedSalesforceMarketingCloudLinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedSalesforceMarketingCloudLinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("useEncryptedEndpoints".equals(fieldName)) {
                    deserializedSalesforceMarketingCloudLinkedServiceTypeProperties.useEncryptedEndpoints = reader.readUntyped();
                    continue;
                }
                if ("useHostVerification".equals(fieldName)) {
                    deserializedSalesforceMarketingCloudLinkedServiceTypeProperties.useHostVerification = reader.readUntyped();
                    continue;
                }
                if ("usePeerVerification".equals(fieldName)) {
                    deserializedSalesforceMarketingCloudLinkedServiceTypeProperties.usePeerVerification = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSalesforceMarketingCloudLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSalesforceMarketingCloudLinkedServiceTypeProperties;
        });
    }
}

