/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.RestServiceAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class RestServiceLinkedServiceTypeProperties
implements JsonSerializable<RestServiceLinkedServiceTypeProperties> {
    private Object url;
    private Object enableServerCertificateValidation;
    private RestServiceAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object authHeaders;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object azureCloudType;
    private Object aadResourceId;
    private String encryptedCredential;
    private CredentialReference credential;
    private Object clientId;
    private SecretBase clientSecret;
    private Object tokenEndpoint;
    private Object resource;
    private Object scope;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalEmbeddedCert;
    private SecretBase servicePrincipalEmbeddedCertPassword;
    private static final ClientLogger LOGGER = new ClientLogger(RestServiceLinkedServiceTypeProperties.class);

    public Object url() {
        return this.url;
    }

    public RestServiceLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object enableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public RestServiceLinkedServiceTypeProperties withEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    public RestServiceAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public RestServiceLinkedServiceTypeProperties withAuthenticationType(RestServiceAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public RestServiceLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public RestServiceLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object authHeaders() {
        return this.authHeaders;
    }

    public RestServiceLinkedServiceTypeProperties withAuthHeaders(Object authHeaders) {
        this.authHeaders = authHeaders;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public RestServiceLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public RestServiceLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public RestServiceLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object azureCloudType() {
        return this.azureCloudType;
    }

    public RestServiceLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public Object aadResourceId() {
        return this.aadResourceId;
    }

    public RestServiceLinkedServiceTypeProperties withAadResourceId(Object aadResourceId) {
        this.aadResourceId = aadResourceId;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public RestServiceLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public RestServiceLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public RestServiceLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public RestServiceLinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public RestServiceLinkedServiceTypeProperties withTokenEndpoint(Object tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    public Object resource() {
        return this.resource;
    }

    public RestServiceLinkedServiceTypeProperties withResource(Object resource) {
        this.resource = resource;
        return this;
    }

    public Object scope() {
        return this.scope;
    }

    public RestServiceLinkedServiceTypeProperties withScope(Object scope) {
        this.scope = scope;
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public RestServiceLinkedServiceTypeProperties withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalEmbeddedCert() {
        return this.servicePrincipalEmbeddedCert;
    }

    public RestServiceLinkedServiceTypeProperties withServicePrincipalEmbeddedCert(SecretBase servicePrincipalEmbeddedCert) {
        this.servicePrincipalEmbeddedCert = servicePrincipalEmbeddedCert;
        return this;
    }

    public SecretBase servicePrincipalEmbeddedCertPassword() {
        return this.servicePrincipalEmbeddedCertPassword;
    }

    public RestServiceLinkedServiceTypeProperties withServicePrincipalEmbeddedCertPassword(SecretBase servicePrincipalEmbeddedCertPassword) {
        this.servicePrincipalEmbeddedCertPassword = servicePrincipalEmbeddedCertPassword;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model RestServiceLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model RestServiceLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
        if (this.servicePrincipalEmbeddedCert() != null) {
            this.servicePrincipalEmbeddedCert().validate();
        }
        if (this.servicePrincipalEmbeddedCertPassword() != null) {
            this.servicePrincipalEmbeddedCertPassword().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.enableServerCertificateValidation != null) {
            jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("userName", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.authHeaders != null) {
            jsonWriter.writeUntypedField("authHeaders", this.authHeaders);
        }
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.tenant != null) {
            jsonWriter.writeUntypedField("tenant", this.tenant);
        }
        if (this.azureCloudType != null) {
            jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
        }
        if (this.aadResourceId != null) {
            jsonWriter.writeUntypedField("aadResourceId", this.aadResourceId);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        if (this.clientId != null) {
            jsonWriter.writeUntypedField("clientId", this.clientId);
        }
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        if (this.tokenEndpoint != null) {
            jsonWriter.writeUntypedField("tokenEndpoint", this.tokenEndpoint);
        }
        if (this.resource != null) {
            jsonWriter.writeUntypedField("resource", this.resource);
        }
        if (this.scope != null) {
            jsonWriter.writeUntypedField("scope", this.scope);
        }
        if (this.servicePrincipalCredentialType != null) {
            jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        }
        jsonWriter.writeJsonField("servicePrincipalEmbeddedCert", (JsonSerializable)this.servicePrincipalEmbeddedCert);
        jsonWriter.writeJsonField("servicePrincipalEmbeddedCertPassword", (JsonSerializable)this.servicePrincipalEmbeddedCertPassword);
        return jsonWriter.writeEndObject();
    }

    public static RestServiceLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RestServiceLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            RestServiceLinkedServiceTypeProperties deserializedRestServiceLinkedServiceTypeProperties = new RestServiceLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.authenticationType = RestServiceAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("enableServerCertificateValidation".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.enableServerCertificateValidation = reader.readUntyped();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authHeaders".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.authHeaders = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("azureCloudType".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.azureCloudType = reader.readUntyped();
                    continue;
                }
                if ("aadResourceId".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.aadResourceId = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tokenEndpoint".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.tokenEndpoint = reader.readUntyped();
                    continue;
                }
                if ("resource".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.resource = reader.readUntyped();
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.scope = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalEmbeddedCert".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.servicePrincipalEmbeddedCert = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalEmbeddedCertPassword".equals(fieldName)) {
                    deserializedRestServiceLinkedServiceTypeProperties.servicePrincipalEmbeddedCertPassword = SecretBase.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestServiceLinkedServiceTypeProperties;
        });
    }
}

