/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import java.io.IOException;

public final class PostgreSqlLinkedServiceTypeProperties
implements JsonSerializable<PostgreSqlLinkedServiceTypeProperties> {
    private Object connectionString;
    private AzureKeyVaultSecretReference password;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(PostgreSqlLinkedServiceTypeProperties.class);

    public Object connectionString() {
        return this.connectionString;
    }

    public PostgreSqlLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.password;
    }

    public PostgreSqlLinkedServiceTypeProperties withPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public PostgreSqlLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.connectionString() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionString in model PostgreSqlLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static PostgreSqlLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PostgreSqlLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            PostgreSqlLinkedServiceTypeProperties deserializedPostgreSqlLinkedServiceTypeProperties = new PostgreSqlLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedPostgreSqlLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedPostgreSqlLinkedServiceTypeProperties.password = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedPostgreSqlLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPostgreSqlLinkedServiceTypeProperties;
        });
    }
}

