/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.HiveAuthenticationType;
import com.azure.resourcemanager.datafactory.models.HiveServerType;
import com.azure.resourcemanager.datafactory.models.HiveThriftTransportProtocol;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class HiveLinkedServiceTypeProperties
implements JsonSerializable<HiveLinkedServiceTypeProperties> {
    private Object host;
    private Object port;
    private HiveServerType serverType;
    private HiveThriftTransportProtocol thriftTransportProtocol;
    private HiveAuthenticationType authenticationType;
    private Object serviceDiscoveryMode;
    private Object zooKeeperNameSpace;
    private Object useNativeQuery;
    private Object username;
    private SecretBase password;
    private Object httpPath;
    private Object enableSsl;
    private Object enableServerCertificateValidation;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private Object allowHostnameCNMismatch;
    private Object allowSelfSignedServerCert;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(HiveLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public HiveLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public HiveLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public HiveServerType serverType() {
        return this.serverType;
    }

    public HiveLinkedServiceTypeProperties withServerType(HiveServerType serverType) {
        this.serverType = serverType;
        return this;
    }

    public HiveThriftTransportProtocol thriftTransportProtocol() {
        return this.thriftTransportProtocol;
    }

    public HiveLinkedServiceTypeProperties withThriftTransportProtocol(HiveThriftTransportProtocol thriftTransportProtocol) {
        this.thriftTransportProtocol = thriftTransportProtocol;
        return this;
    }

    public HiveAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public HiveLinkedServiceTypeProperties withAuthenticationType(HiveAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object serviceDiscoveryMode() {
        return this.serviceDiscoveryMode;
    }

    public HiveLinkedServiceTypeProperties withServiceDiscoveryMode(Object serviceDiscoveryMode) {
        this.serviceDiscoveryMode = serviceDiscoveryMode;
        return this;
    }

    public Object zooKeeperNameSpace() {
        return this.zooKeeperNameSpace;
    }

    public HiveLinkedServiceTypeProperties withZooKeeperNameSpace(Object zooKeeperNameSpace) {
        this.zooKeeperNameSpace = zooKeeperNameSpace;
        return this;
    }

    public Object useNativeQuery() {
        return this.useNativeQuery;
    }

    public HiveLinkedServiceTypeProperties withUseNativeQuery(Object useNativeQuery) {
        this.useNativeQuery = useNativeQuery;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public HiveLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public HiveLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object httpPath() {
        return this.httpPath;
    }

    public HiveLinkedServiceTypeProperties withHttpPath(Object httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    public Object enableSsl() {
        return this.enableSsl;
    }

    public HiveLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object enableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public HiveLinkedServiceTypeProperties withEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    public HiveLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public HiveLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public Object allowHostnameCNMismatch() {
        return this.allowHostnameCNMismatch;
    }

    public HiveLinkedServiceTypeProperties withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        this.allowHostnameCNMismatch = allowHostnameCNMismatch;
        return this;
    }

    public Object allowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public HiveLinkedServiceTypeProperties withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public HiveLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model HiveLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model HiveLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        jsonWriter.writeStringField("serverType", this.serverType == null ? null : this.serverType.toString());
        jsonWriter.writeStringField("thriftTransportProtocol", this.thriftTransportProtocol == null ? null : this.thriftTransportProtocol.toString());
        if (this.serviceDiscoveryMode != null) {
            jsonWriter.writeUntypedField("serviceDiscoveryMode", this.serviceDiscoveryMode);
        }
        if (this.zooKeeperNameSpace != null) {
            jsonWriter.writeUntypedField("zooKeeperNameSpace", this.zooKeeperNameSpace);
        }
        if (this.useNativeQuery != null) {
            jsonWriter.writeUntypedField("useNativeQuery", this.useNativeQuery);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.httpPath != null) {
            jsonWriter.writeUntypedField("httpPath", this.httpPath);
        }
        if (this.enableSsl != null) {
            jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
        }
        if (this.enableServerCertificateValidation != null) {
            jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
        }
        if (this.trustedCertPath != null) {
            jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
        }
        if (this.useSystemTrustStore != null) {
            jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
        }
        if (this.allowHostnameCNMismatch != null) {
            jsonWriter.writeUntypedField("allowHostNameCNMismatch", this.allowHostnameCNMismatch);
        }
        if (this.allowSelfSignedServerCert != null) {
            jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static HiveLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HiveLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            HiveLinkedServiceTypeProperties deserializedHiveLinkedServiceTypeProperties = new HiveLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.authenticationType = HiveAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("serverType".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.serverType = HiveServerType.fromString(reader.getString());
                    continue;
                }
                if ("thriftTransportProtocol".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.thriftTransportProtocol = HiveThriftTransportProtocol.fromString(reader.getString());
                    continue;
                }
                if ("serviceDiscoveryMode".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.serviceDiscoveryMode = reader.readUntyped();
                    continue;
                }
                if ("zooKeeperNameSpace".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.zooKeeperNameSpace = reader.readUntyped();
                    continue;
                }
                if ("useNativeQuery".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.useNativeQuery = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("httpPath".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.httpPath = reader.readUntyped();
                    continue;
                }
                if ("enableSsl".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.enableSsl = reader.readUntyped();
                    continue;
                }
                if ("enableServerCertificateValidation".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.enableServerCertificateValidation = reader.readUntyped();
                    continue;
                }
                if ("trustedCertPath".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.trustedCertPath = reader.readUntyped();
                    continue;
                }
                if ("useSystemTrustStore".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.useSystemTrustStore = reader.readUntyped();
                    continue;
                }
                if ("allowHostNameCNMismatch".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.allowHostnameCNMismatch = reader.readUntyped();
                    continue;
                }
                if ("allowSelfSignedServerCert".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.allowSelfSignedServerCert = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedHiveLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHiveLinkedServiceTypeProperties;
        });
    }
}

