/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.FormatReadSettings;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import java.io.IOException;
import java.util.List;

public final class GetMetadataActivityTypeProperties
implements JsonSerializable<GetMetadataActivityTypeProperties> {
    private DatasetReference dataset;
    private List<Object> fieldList;
    private StoreReadSettings storeSettings;
    private FormatReadSettings formatSettings;
    private static final ClientLogger LOGGER = new ClientLogger(GetMetadataActivityTypeProperties.class);

    public DatasetReference dataset() {
        return this.dataset;
    }

    public GetMetadataActivityTypeProperties withDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    public List<Object> fieldList() {
        return this.fieldList;
    }

    public GetMetadataActivityTypeProperties withFieldList(List<Object> fieldList) {
        this.fieldList = fieldList;
        return this;
    }

    public StoreReadSettings storeSettings() {
        return this.storeSettings;
    }

    public GetMetadataActivityTypeProperties withStoreSettings(StoreReadSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    public FormatReadSettings formatSettings() {
        return this.formatSettings;
    }

    public GetMetadataActivityTypeProperties withFormatSettings(FormatReadSettings formatSettings) {
        this.formatSettings = formatSettings;
        return this;
    }

    public void validate() {
        if (this.dataset() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataset in model GetMetadataActivityTypeProperties"));
        }
        this.dataset().validate();
        if (this.storeSettings() != null) {
            this.storeSettings().validate();
        }
        if (this.formatSettings() != null) {
            this.formatSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
        jsonWriter.writeArrayField("fieldList", this.fieldList, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("storeSettings", (JsonSerializable)this.storeSettings);
        jsonWriter.writeJsonField("formatSettings", (JsonSerializable)this.formatSettings);
        return jsonWriter.writeEndObject();
    }

    public static GetMetadataActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GetMetadataActivityTypeProperties)jsonReader.readObject(reader -> {
            GetMetadataActivityTypeProperties deserializedGetMetadataActivityTypeProperties = new GetMetadataActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataset".equals(fieldName)) {
                    deserializedGetMetadataActivityTypeProperties.dataset = DatasetReference.fromJson(reader);
                    continue;
                }
                if ("fieldList".equals(fieldName)) {
                    List fieldList;
                    deserializedGetMetadataActivityTypeProperties.fieldList = fieldList = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("storeSettings".equals(fieldName)) {
                    deserializedGetMetadataActivityTypeProperties.storeSettings = StoreReadSettings.fromJson(reader);
                    continue;
                }
                if ("formatSettings".equals(fieldName)) {
                    deserializedGetMetadataActivityTypeProperties.formatSettings = FormatReadSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetMetadataActivityTypeProperties;
        });
    }
}

