/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class DynamicsLinkedServiceTypeProperties
implements JsonSerializable<DynamicsLinkedServiceTypeProperties> {
    private Object deploymentType;
    private Object hostname;
    private Object port;
    private Object serviceUri;
    private Object organizationName;
    private Object authenticationType;
    private Object domain;
    private Object username;
    private SecretBase password;
    private Object servicePrincipalId;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private String encryptedCredential;
    private CredentialReference credential;
    private static final ClientLogger LOGGER = new ClientLogger(DynamicsLinkedServiceTypeProperties.class);

    public Object deploymentType() {
        return this.deploymentType;
    }

    public DynamicsLinkedServiceTypeProperties withDeploymentType(Object deploymentType) {
        this.deploymentType = deploymentType;
        return this;
    }

    public Object hostname() {
        return this.hostname;
    }

    public DynamicsLinkedServiceTypeProperties withHostname(Object hostname) {
        this.hostname = hostname;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public DynamicsLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object serviceUri() {
        return this.serviceUri;
    }

    public DynamicsLinkedServiceTypeProperties withServiceUri(Object serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    public Object organizationName() {
        return this.organizationName;
    }

    public DynamicsLinkedServiceTypeProperties withOrganizationName(Object organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    public Object authenticationType() {
        return this.authenticationType;
    }

    public DynamicsLinkedServiceTypeProperties withAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object domain() {
        return this.domain;
    }

    public DynamicsLinkedServiceTypeProperties withDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public DynamicsLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public DynamicsLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public DynamicsLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public DynamicsLinkedServiceTypeProperties withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public DynamicsLinkedServiceTypeProperties withServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public DynamicsLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public DynamicsLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.deploymentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deploymentType in model DynamicsLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model DynamicsLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.servicePrincipalCredential() != null) {
            this.servicePrincipalCredential().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("deploymentType", this.deploymentType);
        jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
        if (this.hostname != null) {
            jsonWriter.writeUntypedField("hostName", this.hostname);
        }
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.serviceUri != null) {
            jsonWriter.writeUntypedField("serviceUri", this.serviceUri);
        }
        if (this.organizationName != null) {
            jsonWriter.writeUntypedField("organizationName", this.organizationName);
        }
        if (this.domain != null) {
            jsonWriter.writeUntypedField("domain", this.domain);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        if (this.servicePrincipalCredentialType != null) {
            jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        }
        jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static DynamicsLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DynamicsLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            DynamicsLinkedServiceTypeProperties deserializedDynamicsLinkedServiceTypeProperties = new DynamicsLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deploymentType".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.deploymentType = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.authenticationType = reader.readUntyped();
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.hostname = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("serviceUri".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.serviceUri = reader.readUntyped();
                    continue;
                }
                if ("organizationName".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.organizationName = reader.readUntyped();
                    continue;
                }
                if ("domain".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.domain = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredential".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.servicePrincipalCredential = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedDynamicsLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDynamicsLinkedServiceTypeProperties;
        });
    }
}

