/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class DynamicsCrmLinkedServiceTypeProperties
implements JsonSerializable<DynamicsCrmLinkedServiceTypeProperties> {
    private Object deploymentType;
    private Object hostname;
    private Object port;
    private Object serviceUri;
    private Object organizationName;
    private Object authenticationType;
    private Object domain;
    private Object username;
    private SecretBase password;
    private Object servicePrincipalId;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private CredentialReference credential;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(DynamicsCrmLinkedServiceTypeProperties.class);

    public Object deploymentType() {
        return this.deploymentType;
    }

    public DynamicsCrmLinkedServiceTypeProperties withDeploymentType(Object deploymentType) {
        this.deploymentType = deploymentType;
        return this;
    }

    public Object hostname() {
        return this.hostname;
    }

    public DynamicsCrmLinkedServiceTypeProperties withHostname(Object hostname) {
        this.hostname = hostname;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public DynamicsCrmLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object serviceUri() {
        return this.serviceUri;
    }

    public DynamicsCrmLinkedServiceTypeProperties withServiceUri(Object serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    public Object organizationName() {
        return this.organizationName;
    }

    public DynamicsCrmLinkedServiceTypeProperties withOrganizationName(Object organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    public Object authenticationType() {
        return this.authenticationType;
    }

    public DynamicsCrmLinkedServiceTypeProperties withAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object domain() {
        return this.domain;
    }

    public DynamicsCrmLinkedServiceTypeProperties withDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public DynamicsCrmLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public DynamicsCrmLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public DynamicsCrmLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public DynamicsCrmLinkedServiceTypeProperties withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public DynamicsCrmLinkedServiceTypeProperties withServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public DynamicsCrmLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public DynamicsCrmLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.deploymentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deploymentType in model DynamicsCrmLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model DynamicsCrmLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.servicePrincipalCredential() != null) {
            this.servicePrincipalCredential().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("deploymentType", this.deploymentType);
        jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
        if (this.hostname != null) {
            jsonWriter.writeUntypedField("hostName", this.hostname);
        }
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.serviceUri != null) {
            jsonWriter.writeUntypedField("serviceUri", this.serviceUri);
        }
        if (this.organizationName != null) {
            jsonWriter.writeUntypedField("organizationName", this.organizationName);
        }
        if (this.domain != null) {
            jsonWriter.writeUntypedField("domain", this.domain);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        if (this.servicePrincipalCredentialType != null) {
            jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        }
        jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static DynamicsCrmLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DynamicsCrmLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            DynamicsCrmLinkedServiceTypeProperties deserializedDynamicsCrmLinkedServiceTypeProperties = new DynamicsCrmLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deploymentType".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.deploymentType = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.authenticationType = reader.readUntyped();
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.hostname = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("serviceUri".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.serviceUri = reader.readUntyped();
                    continue;
                }
                if ("organizationName".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.organizationName = reader.readUntyped();
                    continue;
                }
                if ("domain".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.domain = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredential".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.servicePrincipalCredential = SecretBase.fromJson(reader);
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedDynamicsCrmLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDynamicsCrmLinkedServiceTypeProperties;
        });
    }
}

