/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;

public final class BlobTriggerTypeProperties
implements JsonSerializable<BlobTriggerTypeProperties> {
    private String folderPath;
    private int maxConcurrency;
    private LinkedServiceReference linkedService;
    private static final ClientLogger LOGGER = new ClientLogger(BlobTriggerTypeProperties.class);

    public String folderPath() {
        return this.folderPath;
    }

    public BlobTriggerTypeProperties withFolderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public int maxConcurrency() {
        return this.maxConcurrency;
    }

    public BlobTriggerTypeProperties withMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public LinkedServiceReference linkedService() {
        return this.linkedService;
    }

    public BlobTriggerTypeProperties withLinkedService(LinkedServiceReference linkedService) {
        this.linkedService = linkedService;
        return this;
    }

    public void validate() {
        if (this.folderPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property folderPath in model BlobTriggerTypeProperties"));
        }
        if (this.linkedService() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedService in model BlobTriggerTypeProperties"));
        }
        this.linkedService().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("folderPath", this.folderPath);
        jsonWriter.writeIntField("maxConcurrency", this.maxConcurrency);
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.linkedService);
        return jsonWriter.writeEndObject();
    }

    public static BlobTriggerTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BlobTriggerTypeProperties)jsonReader.readObject(reader -> {
            BlobTriggerTypeProperties deserializedBlobTriggerTypeProperties = new BlobTriggerTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedBlobTriggerTypeProperties.folderPath = reader.getString();
                    continue;
                }
                if ("maxConcurrency".equals(fieldName)) {
                    deserializedBlobTriggerTypeProperties.maxConcurrency = reader.getInt();
                    continue;
                }
                if ("linkedService".equals(fieldName)) {
                    deserializedBlobTriggerTypeProperties.linkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobTriggerTypeProperties;
        });
    }
}

