/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureBatchLinkedServiceTypeProperties
implements JsonSerializable<AzureBatchLinkedServiceTypeProperties> {
    private Object accountName;
    private SecretBase accessKey;
    private Object batchUri;
    private Object poolName;
    private LinkedServiceReference linkedServiceName;
    private String encryptedCredential;
    private CredentialReference credential;
    private static final ClientLogger LOGGER = new ClientLogger(AzureBatchLinkedServiceTypeProperties.class);

    public Object accountName() {
        return this.accountName;
    }

    public AzureBatchLinkedServiceTypeProperties withAccountName(Object accountName) {
        this.accountName = accountName;
        return this;
    }

    public SecretBase accessKey() {
        return this.accessKey;
    }

    public AzureBatchLinkedServiceTypeProperties withAccessKey(SecretBase accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public Object batchUri() {
        return this.batchUri;
    }

    public AzureBatchLinkedServiceTypeProperties withBatchUri(Object batchUri) {
        this.batchUri = batchUri;
        return this;
    }

    public Object poolName() {
        return this.poolName;
    }

    public AzureBatchLinkedServiceTypeProperties withPoolName(Object poolName) {
        this.poolName = poolName;
        return this;
    }

    public LinkedServiceReference linkedServiceName() {
        return this.linkedServiceName;
    }

    public AzureBatchLinkedServiceTypeProperties withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureBatchLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureBatchLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.accountName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountName in model AzureBatchLinkedServiceTypeProperties"));
        }
        if (this.accessKey() != null) {
            this.accessKey().validate();
        }
        if (this.batchUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property batchUri in model AzureBatchLinkedServiceTypeProperties"));
        }
        if (this.poolName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property poolName in model AzureBatchLinkedServiceTypeProperties"));
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model AzureBatchLinkedServiceTypeProperties"));
        }
        this.linkedServiceName().validate();
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("accountName", this.accountName);
        jsonWriter.writeUntypedField("batchUri", this.batchUri);
        jsonWriter.writeUntypedField("poolName", this.poolName);
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName);
        jsonWriter.writeJsonField("accessKey", (JsonSerializable)this.accessKey);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureBatchLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBatchLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureBatchLinkedServiceTypeProperties deserializedAzureBatchLinkedServiceTypeProperties = new AzureBatchLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedAzureBatchLinkedServiceTypeProperties.accountName = reader.readUntyped();
                    continue;
                }
                if ("batchUri".equals(fieldName)) {
                    deserializedAzureBatchLinkedServiceTypeProperties.batchUri = reader.readUntyped();
                    continue;
                }
                if ("poolName".equals(fieldName)) {
                    deserializedAzureBatchLinkedServiceTypeProperties.poolName = reader.readUntyped();
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureBatchLinkedServiceTypeProperties.linkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("accessKey".equals(fieldName)) {
                    deserializedAzureBatchLinkedServiceTypeProperties.accessKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureBatchLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureBatchLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBatchLinkedServiceTypeProperties;
        });
    }
}

