/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AmazonS3LinkedServiceTypeProperties
implements JsonSerializable<AmazonS3LinkedServiceTypeProperties> {
    private Object authenticationType;
    private Object accessKeyId;
    private SecretBase secretAccessKey;
    private Object serviceUrl;
    private SecretBase sessionToken;
    private String encryptedCredential;

    public Object authenticationType() {
        return this.authenticationType;
    }

    public AmazonS3LinkedServiceTypeProperties withAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object accessKeyId() {
        return this.accessKeyId;
    }

    public AmazonS3LinkedServiceTypeProperties withAccessKeyId(Object accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    public SecretBase secretAccessKey() {
        return this.secretAccessKey;
    }

    public AmazonS3LinkedServiceTypeProperties withSecretAccessKey(SecretBase secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
        return this;
    }

    public Object serviceUrl() {
        return this.serviceUrl;
    }

    public AmazonS3LinkedServiceTypeProperties withServiceUrl(Object serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public SecretBase sessionToken() {
        return this.sessionToken;
    }

    public AmazonS3LinkedServiceTypeProperties withSessionToken(SecretBase sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AmazonS3LinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.secretAccessKey() != null) {
            this.secretAccessKey().validate();
        }
        if (this.sessionToken() != null) {
            this.sessionToken().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.authenticationType != null) {
            jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
        }
        if (this.accessKeyId != null) {
            jsonWriter.writeUntypedField("accessKeyId", this.accessKeyId);
        }
        jsonWriter.writeJsonField("secretAccessKey", (JsonSerializable)this.secretAccessKey);
        if (this.serviceUrl != null) {
            jsonWriter.writeUntypedField("serviceUrl", this.serviceUrl);
        }
        jsonWriter.writeJsonField("sessionToken", (JsonSerializable)this.sessionToken);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static AmazonS3LinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonS3LinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AmazonS3LinkedServiceTypeProperties deserializedAmazonS3LinkedServiceTypeProperties = new AmazonS3LinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authenticationType".equals(fieldName)) {
                    deserializedAmazonS3LinkedServiceTypeProperties.authenticationType = reader.readUntyped();
                    continue;
                }
                if ("accessKeyId".equals(fieldName)) {
                    deserializedAmazonS3LinkedServiceTypeProperties.accessKeyId = reader.readUntyped();
                    continue;
                }
                if ("secretAccessKey".equals(fieldName)) {
                    deserializedAmazonS3LinkedServiceTypeProperties.secretAccessKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("serviceUrl".equals(fieldName)) {
                    deserializedAmazonS3LinkedServiceTypeProperties.serviceUrl = reader.readUntyped();
                    continue;
                }
                if ("sessionToken".equals(fieldName)) {
                    deserializedAmazonS3LinkedServiceTypeProperties.sessionToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAmazonS3LinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmazonS3LinkedServiceTypeProperties;
        });
    }
}

