/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SparkJobReferenceType;
import java.io.IOException;

public final class SynapseSparkJobReference
implements JsonSerializable<SynapseSparkJobReference> {
    private SparkJobReferenceType type;
    private Object referenceName;
    private static final ClientLogger LOGGER = new ClientLogger(SynapseSparkJobReference.class);

    public SparkJobReferenceType type() {
        return this.type;
    }

    public SynapseSparkJobReference withType(SparkJobReferenceType type) {
        this.type = type;
        return this;
    }

    public Object referenceName() {
        return this.referenceName;
    }

    public SynapseSparkJobReference withReferenceName(Object referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model SynapseSparkJobReference"));
        }
        if (this.referenceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceName in model SynapseSparkJobReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeUntypedField("referenceName", this.referenceName);
        return jsonWriter.writeEndObject();
    }

    public static SynapseSparkJobReference fromJson(JsonReader jsonReader) throws IOException {
        return (SynapseSparkJobReference)jsonReader.readObject(reader -> {
            SynapseSparkJobReference deserializedSynapseSparkJobReference = new SynapseSparkJobReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSynapseSparkJobReference.type = SparkJobReferenceType.fromString(reader.getString());
                    continue;
                }
                if ("referenceName".equals(fieldName)) {
                    deserializedSynapseSparkJobReference.referenceName = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSynapseSparkJobReference;
        });
    }
}

