/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AmazonS3CompatibleReadSettings;
import com.azure.resourcemanager.datafactory.models.AmazonS3ReadSettings;
import com.azure.resourcemanager.datafactory.models.AzureBlobFSReadSettings;
import com.azure.resourcemanager.datafactory.models.AzureBlobStorageReadSettings;
import com.azure.resourcemanager.datafactory.models.AzureDataLakeStoreReadSettings;
import com.azure.resourcemanager.datafactory.models.AzureFileStorageReadSettings;
import com.azure.resourcemanager.datafactory.models.FileServerReadSettings;
import com.azure.resourcemanager.datafactory.models.FtpReadSettings;
import com.azure.resourcemanager.datafactory.models.GoogleCloudStorageReadSettings;
import com.azure.resourcemanager.datafactory.models.HdfsReadSettings;
import com.azure.resourcemanager.datafactory.models.HttpReadSettings;
import com.azure.resourcemanager.datafactory.models.LakeHouseReadSettings;
import com.azure.resourcemanager.datafactory.models.OracleCloudStorageReadSettings;
import com.azure.resourcemanager.datafactory.models.SftpReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class StoreReadSettings
implements JsonSerializable<StoreReadSettings> {
    private String type = "StoreReadSettings";
    private Object maxConcurrentConnections;
    private Object disableMetricsCollection;
    private Map<String, Object> additionalProperties;

    public String type() {
        return this.type;
    }

    public Object maxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    public StoreReadSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
        return this;
    }

    public Object disableMetricsCollection() {
        return this.disableMetricsCollection;
    }

    public StoreReadSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        this.disableMetricsCollection = disableMetricsCollection;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public StoreReadSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections);
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static StoreReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (StoreReadSettings)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                StoreReadSettings storeReadSettings;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AzureBlobStorageReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AzureBlobStorageReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("AzureBlobFSReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AzureBlobFSReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("AzureDataLakeStoreReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AzureDataLakeStoreReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("AmazonS3ReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AmazonS3ReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("FileServerReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = FileServerReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("AzureFileStorageReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AzureFileStorageReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("AmazonS3CompatibleReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AmazonS3CompatibleReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("OracleCloudStorageReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = OracleCloudStorageReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("GoogleCloudStorageReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = GoogleCloudStorageReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("FtpReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = FtpReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("SftpReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = SftpReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("HttpReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = HttpReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("HdfsReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = HdfsReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("LakeHouseReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = LakeHouseReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                storeReadSettings = StoreReadSettings.fromJsonKnownDiscriminator(readerToUse.reset());
                return storeReadSettings;
            }
        });
    }

    static StoreReadSettings fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (StoreReadSettings)jsonReader.readObject(reader -> {
            StoreReadSettings deserializedStoreReadSettings = new StoreReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedStoreReadSettings.type = reader.getString();
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedStoreReadSettings.maxConcurrentConnections = reader.readUntyped();
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedStoreReadSettings.disableMetricsCollection = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedStoreReadSettings.additionalProperties = additionalProperties;
            return deserializedStoreReadSettings;
        });
    }
}

