/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadata;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadataType;
import com.azure.resourcemanager.datafactory.models.SsisParameter;
import java.io.IOException;
import java.util.List;

public final class SsisPackage
extends SsisObjectMetadata {
    private SsisObjectMetadataType type = SsisObjectMetadataType.PACKAGE;
    private Long folderId;
    private Long projectVersion;
    private Long projectId;
    private List<SsisParameter> parameters;

    @Override
    public SsisObjectMetadataType type() {
        return this.type;
    }

    public Long folderId() {
        return this.folderId;
    }

    public SsisPackage withFolderId(Long folderId) {
        this.folderId = folderId;
        return this;
    }

    public Long projectVersion() {
        return this.projectVersion;
    }

    public SsisPackage withProjectVersion(Long projectVersion) {
        this.projectVersion = projectVersion;
        return this;
    }

    public Long projectId() {
        return this.projectId;
    }

    public SsisPackage withProjectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    public List<SsisParameter> parameters() {
        return this.parameters;
    }

    public SsisPackage withParameters(List<SsisParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public SsisPackage withId(Long id) {
        super.withId(id);
        return this;
    }

    @Override
    public SsisPackage withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SsisPackage withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public void validate() {
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("id", (Number)this.id());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("folderId", (Number)this.folderId);
        jsonWriter.writeNumberField("projectVersion", (Number)this.projectVersion);
        jsonWriter.writeNumberField("projectId", (Number)this.projectId);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SsisPackage fromJson(JsonReader jsonReader) throws IOException {
        return (SsisPackage)jsonReader.readObject(reader -> {
            SsisPackage deserializedSsisPackage = new SsisPackage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSsisPackage.withId((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSsisPackage.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSsisPackage.withDescription(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSsisPackage.type = SsisObjectMetadataType.fromString(reader.getString());
                    continue;
                }
                if ("folderId".equals(fieldName)) {
                    deserializedSsisPackage.folderId = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("projectVersion".equals(fieldName)) {
                    deserializedSsisPackage.projectVersion = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("projectId".equals(fieldName)) {
                    deserializedSsisPackage.projectId = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedSsisPackage.parameters = parameters = reader.readArray(reader1 -> SsisParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisPackage;
        });
    }
}

