/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.SnowflakeImportCopyCommand;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SnowflakeSink
extends CopySink {
    private String type = "SnowflakeSink";
    private Object preCopyScript;
    private SnowflakeImportCopyCommand importSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object preCopyScript() {
        return this.preCopyScript;
    }

    public SnowflakeSink withPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public SnowflakeImportCopyCommand importSettings() {
        return this.importSettings;
    }

    public SnowflakeSink withImportSettings(SnowflakeImportCopyCommand importSettings) {
        this.importSettings = importSettings;
        return this;
    }

    @Override
    public SnowflakeSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SnowflakeSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SnowflakeSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SnowflakeSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SnowflakeSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SnowflakeSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.importSettings() != null) {
            this.importSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        jsonWriter.writeJsonField("importSettings", (JsonSerializable)this.importSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeSink fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeSink)jsonReader.readObject(reader -> {
            SnowflakeSink deserializedSnowflakeSink = new SnowflakeSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSnowflakeSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSnowflakeSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSnowflakeSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSnowflakeSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSnowflakeSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSnowflakeSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnowflakeSink.type = reader.getString();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedSnowflakeSink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("importSettings".equals(fieldName)) {
                    deserializedSnowflakeSink.importSettings = SnowflakeImportCopyCommand.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSnowflakeSink.withAdditionalProperties(additionalProperties);
            return deserializedSnowflakeSink;
        });
    }
}

