/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SharePointOnlineListSource
extends CopySource {
    private String type = "SharePointOnlineListSource";
    private Object query;
    private Object httpRequestTimeout;

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public SharePointOnlineListSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object httpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public SharePointOnlineListSource withHttpRequestTimeout(Object httpRequestTimeout) {
        this.httpRequestTimeout = httpRequestTimeout;
        return this;
    }

    @Override
    public SharePointOnlineListSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SharePointOnlineListSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SharePointOnlineListSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SharePointOnlineListSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("query", this.query);
        jsonWriter.writeUntypedField("httpRequestTimeout", this.httpRequestTimeout);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SharePointOnlineListSource fromJson(JsonReader jsonReader) throws IOException {
        return (SharePointOnlineListSource)jsonReader.readObject(reader -> {
            SharePointOnlineListSource deserializedSharePointOnlineListSource = new SharePointOnlineListSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSharePointOnlineListSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSharePointOnlineListSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSharePointOnlineListSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSharePointOnlineListSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSharePointOnlineListSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedSharePointOnlineListSource.query = reader.readUntyped();
                    continue;
                }
                if ("httpRequestTimeout".equals(fieldName)) {
                    deserializedSharePointOnlineListSource.httpRequestTimeout = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSharePointOnlineListSource.withAdditionalProperties(additionalProperties);
            return deserializedSharePointOnlineListSource;
        });
    }
}

