/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SftpServerLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SftpAuthenticationType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SftpServerLinkedService
extends LinkedService {
    private String type = "Sftp";
    private SftpServerLinkedServiceTypeProperties innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SftpServerLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    SftpServerLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SftpServerLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public SftpServerLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public SftpServerLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SftpServerLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SftpServerLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object host() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().host();
    }

    public SftpServerLinkedService withHost(Object host) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHost(host);
        return this;
    }

    public Object port() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().port();
    }

    public SftpServerLinkedService withPort(Object port) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPort(port);
        return this;
    }

    public SftpAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public SftpServerLinkedService withAuthenticationType(SftpAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public SftpServerLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public SftpServerLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public SftpServerLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public Object privateKeyPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().privateKeyPath();
    }

    public SftpServerLinkedService withPrivateKeyPath(Object privateKeyPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPrivateKeyPath(privateKeyPath);
        return this;
    }

    public SecretBase privateKeyContent() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().privateKeyContent();
    }

    public SftpServerLinkedService withPrivateKeyContent(SecretBase privateKeyContent) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPrivateKeyContent(privateKeyContent);
        return this;
    }

    public SecretBase passPhrase() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().passPhrase();
    }

    public SftpServerLinkedService withPassPhrase(SecretBase passPhrase) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassPhrase(passPhrase);
        return this;
    }

    public Object skipHostKeyValidation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().skipHostKeyValidation();
    }

    public SftpServerLinkedService withSkipHostKeyValidation(Object skipHostKeyValidation) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSkipHostKeyValidation(skipHostKeyValidation);
        return this;
    }

    public Object hostKeyFingerprint() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().hostKeyFingerprint();
    }

    public SftpServerLinkedService withHostKeyFingerprint(Object hostKeyFingerprint) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SftpServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHostKeyFingerprint(hostKeyFingerprint);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SftpServerLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SftpServerLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SftpServerLinkedService)jsonReader.readObject(reader -> {
            SftpServerLinkedService deserializedSftpServerLinkedService = new SftpServerLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSftpServerLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSftpServerLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSftpServerLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSftpServerLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSftpServerLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSftpServerLinkedService.innerTypeProperties = SftpServerLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSftpServerLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSftpServerLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedSftpServerLinkedService;
        });
    }
}

