/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ServicePrincipalCredentialTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.Credential;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ServicePrincipalCredential
extends Credential {
    private String type = "ServicePrincipal";
    private ServicePrincipalCredentialTypeProperties innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ServicePrincipalCredential.class);

    @Override
    public String type() {
        return this.type;
    }

    ServicePrincipalCredentialTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ServicePrincipalCredential withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ServicePrincipalCredential withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    public ServicePrincipalCredential withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    public AzureKeyVaultSecretReference servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    public ServicePrincipalCredential withServicePrincipalKey(AzureKeyVaultSecretReference servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    public ServicePrincipalCredential withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ServicePrincipalCredential"));
        }
        this.innerTypeProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ServicePrincipalCredential fromJson(JsonReader jsonReader) throws IOException {
        return (ServicePrincipalCredential)jsonReader.readObject(reader -> {
            ServicePrincipalCredential deserializedServicePrincipalCredential = new ServicePrincipalCredential();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedServicePrincipalCredential.withDescription(reader.getString());
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedServicePrincipalCredential.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedServicePrincipalCredential.innerTypeProperties = ServicePrincipalCredentialTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServicePrincipalCredential.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedServicePrincipalCredential.withAdditionalProperties(additionalProperties);
            return deserializedServicePrincipalCredential;
        });
    }
}

