/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class SecureString
extends SecretBase {
    private String type = "SecureString";
    private String value;
    private static final ClientLogger LOGGER = new ClientLogger(SecureString.class);

    @Override
    public String type() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public SecureString withValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SecureString"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static SecureString fromJson(JsonReader jsonReader) throws IOException {
        return (SecureString)jsonReader.readObject(reader -> {
            SecureString deserializedSecureString = new SecureString();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedSecureString.value = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSecureString.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecureString;
        });
    }
}

