/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SapTablePartitionSettings;
import com.azure.resourcemanager.datafactory.models.TabularSource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SapTableSource
extends TabularSource {
    private String type = "SapTableSource";
    private Object rowCount;
    private Object rowSkips;
    private Object rfcTableFields;
    private Object rfcTableOptions;
    private Object batchSize;
    private Object customRfcReadTableFunctionModule;
    private Object sapDataColumnDelimiter;
    private Object partitionOption;
    private SapTablePartitionSettings partitionSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object rowCount() {
        return this.rowCount;
    }

    public SapTableSource withRowCount(Object rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    public Object rowSkips() {
        return this.rowSkips;
    }

    public SapTableSource withRowSkips(Object rowSkips) {
        this.rowSkips = rowSkips;
        return this;
    }

    public Object rfcTableFields() {
        return this.rfcTableFields;
    }

    public SapTableSource withRfcTableFields(Object rfcTableFields) {
        this.rfcTableFields = rfcTableFields;
        return this;
    }

    public Object rfcTableOptions() {
        return this.rfcTableOptions;
    }

    public SapTableSource withRfcTableOptions(Object rfcTableOptions) {
        this.rfcTableOptions = rfcTableOptions;
        return this;
    }

    public Object batchSize() {
        return this.batchSize;
    }

    public SapTableSource withBatchSize(Object batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Object customRfcReadTableFunctionModule() {
        return this.customRfcReadTableFunctionModule;
    }

    public SapTableSource withCustomRfcReadTableFunctionModule(Object customRfcReadTableFunctionModule) {
        this.customRfcReadTableFunctionModule = customRfcReadTableFunctionModule;
        return this;
    }

    public Object sapDataColumnDelimiter() {
        return this.sapDataColumnDelimiter;
    }

    public SapTableSource withSapDataColumnDelimiter(Object sapDataColumnDelimiter) {
        this.sapDataColumnDelimiter = sapDataColumnDelimiter;
        return this;
    }

    public Object partitionOption() {
        return this.partitionOption;
    }

    public SapTableSource withPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public SapTablePartitionSettings partitionSettings() {
        return this.partitionSettings;
    }

    public SapTableSource withPartitionSettings(SapTablePartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    @Override
    public SapTableSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public SapTableSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public SapTableSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SapTableSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SapTableSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SapTableSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.partitionSettings() != null) {
            this.partitionSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout());
        jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("rowCount", this.rowCount);
        jsonWriter.writeUntypedField("rowSkips", this.rowSkips);
        jsonWriter.writeUntypedField("rfcTableFields", this.rfcTableFields);
        jsonWriter.writeUntypedField("rfcTableOptions", this.rfcTableOptions);
        jsonWriter.writeUntypedField("batchSize", this.batchSize);
        jsonWriter.writeUntypedField("customRfcReadTableFunctionModule", this.customRfcReadTableFunctionModule);
        jsonWriter.writeUntypedField("sapDataColumnDelimiter", this.sapDataColumnDelimiter);
        jsonWriter.writeUntypedField("partitionOption", this.partitionOption);
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapTableSource fromJson(JsonReader jsonReader) throws IOException {
        return (SapTableSource)jsonReader.readObject(reader -> {
            SapTableSource deserializedSapTableSource = new SapTableSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSapTableSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSapTableSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSapTableSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSapTableSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedSapTableSource.withQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedSapTableSource.withAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapTableSource.type = reader.getString();
                    continue;
                }
                if ("rowCount".equals(fieldName)) {
                    deserializedSapTableSource.rowCount = reader.readUntyped();
                    continue;
                }
                if ("rowSkips".equals(fieldName)) {
                    deserializedSapTableSource.rowSkips = reader.readUntyped();
                    continue;
                }
                if ("rfcTableFields".equals(fieldName)) {
                    deserializedSapTableSource.rfcTableFields = reader.readUntyped();
                    continue;
                }
                if ("rfcTableOptions".equals(fieldName)) {
                    deserializedSapTableSource.rfcTableOptions = reader.readUntyped();
                    continue;
                }
                if ("batchSize".equals(fieldName)) {
                    deserializedSapTableSource.batchSize = reader.readUntyped();
                    continue;
                }
                if ("customRfcReadTableFunctionModule".equals(fieldName)) {
                    deserializedSapTableSource.customRfcReadTableFunctionModule = reader.readUntyped();
                    continue;
                }
                if ("sapDataColumnDelimiter".equals(fieldName)) {
                    deserializedSapTableSource.sapDataColumnDelimiter = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedSapTableSource.partitionOption = reader.readUntyped();
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedSapTableSource.partitionSettings = SapTablePartitionSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapTableSource.withAdditionalProperties(additionalProperties);
            return deserializedSapTableSource;
        });
    }
}

