/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.SalesforceSinkWriteBehavior;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SalesforceServiceCloudSink
extends CopySink {
    private String type = "SalesforceServiceCloudSink";
    private SalesforceSinkWriteBehavior writeBehavior;
    private Object externalIdFieldName;
    private Object ignoreNullValues;

    @Override
    public String type() {
        return this.type;
    }

    public SalesforceSinkWriteBehavior writeBehavior() {
        return this.writeBehavior;
    }

    public SalesforceServiceCloudSink withWriteBehavior(SalesforceSinkWriteBehavior writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public Object externalIdFieldName() {
        return this.externalIdFieldName;
    }

    public SalesforceServiceCloudSink withExternalIdFieldName(Object externalIdFieldName) {
        this.externalIdFieldName = externalIdFieldName;
        return this;
    }

    public Object ignoreNullValues() {
        return this.ignoreNullValues;
    }

    public SalesforceServiceCloudSink withIgnoreNullValues(Object ignoreNullValues) {
        this.ignoreNullValues = ignoreNullValues;
        return this;
    }

    @Override
    public SalesforceServiceCloudSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SalesforceServiceCloudSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SalesforceServiceCloudSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SalesforceServiceCloudSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SalesforceServiceCloudSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SalesforceServiceCloudSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("writeBehavior", this.writeBehavior == null ? null : this.writeBehavior.toString());
        jsonWriter.writeUntypedField("externalIdFieldName", this.externalIdFieldName);
        jsonWriter.writeUntypedField("ignoreNullValues", this.ignoreNullValues);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceServiceCloudSink fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceServiceCloudSink)jsonReader.readObject(reader -> {
            SalesforceServiceCloudSink deserializedSalesforceServiceCloudSink = new SalesforceServiceCloudSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSalesforceServiceCloudSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSalesforceServiceCloudSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSalesforceServiceCloudSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSalesforceServiceCloudSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSalesforceServiceCloudSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSalesforceServiceCloudSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceServiceCloudSink.type = reader.getString();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedSalesforceServiceCloudSink.writeBehavior = SalesforceSinkWriteBehavior.fromString(reader.getString());
                    continue;
                }
                if ("externalIdFieldName".equals(fieldName)) {
                    deserializedSalesforceServiceCloudSink.externalIdFieldName = reader.readUntyped();
                    continue;
                }
                if ("ignoreNullValues".equals(fieldName)) {
                    deserializedSalesforceServiceCloudSink.ignoreNullValues = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceServiceCloudSink.withAdditionalProperties(additionalProperties);
            return deserializedSalesforceServiceCloudSink;
        });
    }
}

