/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RestSink
extends CopySink {
    private String type = "RestSink";
    private Object requestMethod;
    private Object additionalHeaders;
    private Object httpRequestTimeout;
    private Object requestInterval;
    private Object httpCompressionType;

    @Override
    public String type() {
        return this.type;
    }

    public Object requestMethod() {
        return this.requestMethod;
    }

    public RestSink withRequestMethod(Object requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public Object additionalHeaders() {
        return this.additionalHeaders;
    }

    public RestSink withAdditionalHeaders(Object additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    public Object httpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public RestSink withHttpRequestTimeout(Object httpRequestTimeout) {
        this.httpRequestTimeout = httpRequestTimeout;
        return this;
    }

    public Object requestInterval() {
        return this.requestInterval;
    }

    public RestSink withRequestInterval(Object requestInterval) {
        this.requestInterval = requestInterval;
        return this;
    }

    public Object httpCompressionType() {
        return this.httpCompressionType;
    }

    public RestSink withHttpCompressionType(Object httpCompressionType) {
        this.httpCompressionType = httpCompressionType;
        return this;
    }

    @Override
    public RestSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public RestSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public RestSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public RestSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public RestSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public RestSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("requestMethod", this.requestMethod);
        jsonWriter.writeUntypedField("additionalHeaders", this.additionalHeaders);
        jsonWriter.writeUntypedField("httpRequestTimeout", this.httpRequestTimeout);
        jsonWriter.writeUntypedField("requestInterval", this.requestInterval);
        jsonWriter.writeUntypedField("httpCompressionType", this.httpCompressionType);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RestSink fromJson(JsonReader jsonReader) throws IOException {
        return (RestSink)jsonReader.readObject(reader -> {
            RestSink deserializedRestSink = new RestSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedRestSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedRestSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedRestSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedRestSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedRestSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedRestSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestSink.type = reader.getString();
                    continue;
                }
                if ("requestMethod".equals(fieldName)) {
                    deserializedRestSink.requestMethod = reader.readUntyped();
                    continue;
                }
                if ("additionalHeaders".equals(fieldName)) {
                    deserializedRestSink.additionalHeaders = reader.readUntyped();
                    continue;
                }
                if ("httpRequestTimeout".equals(fieldName)) {
                    deserializedRestSink.httpRequestTimeout = reader.readUntyped();
                    continue;
                }
                if ("requestInterval".equals(fieldName)) {
                    deserializedRestSink.requestInterval = reader.readUntyped();
                    continue;
                }
                if ("httpCompressionType".equals(fieldName)) {
                    deserializedRestSink.httpCompressionType = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRestSink.withAdditionalProperties(additionalProperties);
            return deserializedRestSink;
        });
    }
}

