/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.RestResourceDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class RestResourceDataset
extends Dataset {
    private String type = "RestResource";
    private RestResourceDatasetTypeProperties innerTypeProperties;
    private static final ClientLogger LOGGER = new ClientLogger(RestResourceDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    RestResourceDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public RestResourceDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public RestResourceDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public RestResourceDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public RestResourceDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public RestResourceDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public RestResourceDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public RestResourceDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object relativeUrl() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().relativeUrl();
    }

    public RestResourceDataset withRelativeUrl(Object relativeUrl) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withRelativeUrl(relativeUrl);
        return this;
    }

    public Object requestMethod() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestMethod();
    }

    public RestResourceDataset withRequestMethod(Object requestMethod) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withRequestMethod(requestMethod);
        return this;
    }

    public Object requestBody() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestBody();
    }

    public RestResourceDataset withRequestBody(Object requestBody) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withRequestBody(requestBody);
        return this;
    }

    public Map<String, Object> additionalHeaders() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().additionalHeaders();
    }

    public RestResourceDataset withAdditionalHeaders(Map<String, Object> additionalHeaders) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withAdditionalHeaders(additionalHeaders);
        return this;
    }

    public Map<String, Object> paginationRules() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().paginationRules();
    }

    public RestResourceDataset withPaginationRules(Map<String, Object> paginationRules) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withPaginationRules(paginationRules);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model RestResourceDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeUntypedField("structure", this.structure());
        jsonWriter.writeUntypedField("schema", this.schema());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RestResourceDataset fromJson(JsonReader jsonReader) throws IOException {
        return (RestResourceDataset)jsonReader.readObject(reader -> {
            RestResourceDataset deserializedRestResourceDataset = new RestResourceDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedRestResourceDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRestResourceDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedRestResourceDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedRestResourceDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedRestResourceDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedRestResourceDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedRestResourceDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestResourceDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedRestResourceDataset.innerTypeProperties = RestResourceDatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRestResourceDataset.withAdditionalProperties(additionalProperties);
            return deserializedRestResourceDataset;
        });
    }
}

