/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.PipelineResourceInner;
import java.io.IOException;
import java.util.List;

public final class PipelineListResponse
implements JsonSerializable<PipelineListResponse> {
    private List<PipelineResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(PipelineListResponse.class);

    public List<PipelineResourceInner> value() {
        return this.value;
    }

    public PipelineListResponse withValue(List<PipelineResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public PipelineListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model PipelineListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static PipelineListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (PipelineListResponse)jsonReader.readObject(reader -> {
            PipelineListResponse deserializedPipelineListResponse = new PipelineListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedPipelineListResponse.value = value = reader.readArray(reader1 -> PipelineResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedPipelineListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPipelineListResponse;
        });
    }
}

