/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Office365Source
extends CopySource {
    private String type = "Office365Source";
    private Object allowedGroups;
    private Object userScopeFilterUri;
    private Object dateFilterColumn;
    private Object startTime;
    private Object endTime;
    private Object outputColumns;

    @Override
    public String type() {
        return this.type;
    }

    public Object allowedGroups() {
        return this.allowedGroups;
    }

    public Office365Source withAllowedGroups(Object allowedGroups) {
        this.allowedGroups = allowedGroups;
        return this;
    }

    public Object userScopeFilterUri() {
        return this.userScopeFilterUri;
    }

    public Office365Source withUserScopeFilterUri(Object userScopeFilterUri) {
        this.userScopeFilterUri = userScopeFilterUri;
        return this;
    }

    public Object dateFilterColumn() {
        return this.dateFilterColumn;
    }

    public Office365Source withDateFilterColumn(Object dateFilterColumn) {
        this.dateFilterColumn = dateFilterColumn;
        return this;
    }

    public Object startTime() {
        return this.startTime;
    }

    public Office365Source withStartTime(Object startTime) {
        this.startTime = startTime;
        return this;
    }

    public Object endTime() {
        return this.endTime;
    }

    public Office365Source withEndTime(Object endTime) {
        this.endTime = endTime;
        return this;
    }

    public Object outputColumns() {
        return this.outputColumns;
    }

    public Office365Source withOutputColumns(Object outputColumns) {
        this.outputColumns = outputColumns;
        return this;
    }

    @Override
    public Office365Source withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public Office365Source withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public Office365Source withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public Office365Source withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("allowedGroups", this.allowedGroups);
        jsonWriter.writeUntypedField("userScopeFilterUri", this.userScopeFilterUri);
        jsonWriter.writeUntypedField("dateFilterColumn", this.dateFilterColumn);
        jsonWriter.writeUntypedField("startTime", this.startTime);
        jsonWriter.writeUntypedField("endTime", this.endTime);
        jsonWriter.writeUntypedField("outputColumns", this.outputColumns);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Office365Source fromJson(JsonReader jsonReader) throws IOException {
        return (Office365Source)jsonReader.readObject(reader -> {
            Office365Source deserializedOffice365Source = new Office365Source();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedOffice365Source.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedOffice365Source.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedOffice365Source.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedOffice365Source.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOffice365Source.type = reader.getString();
                    continue;
                }
                if ("allowedGroups".equals(fieldName)) {
                    deserializedOffice365Source.allowedGroups = reader.readUntyped();
                    continue;
                }
                if ("userScopeFilterUri".equals(fieldName)) {
                    deserializedOffice365Source.userScopeFilterUri = reader.readUntyped();
                    continue;
                }
                if ("dateFilterColumn".equals(fieldName)) {
                    deserializedOffice365Source.dateFilterColumn = reader.readUntyped();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedOffice365Source.startTime = reader.readUntyped();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedOffice365Source.endTime = reader.readUntyped();
                    continue;
                }
                if ("outputColumns".equals(fieldName)) {
                    deserializedOffice365Source.outputColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedOffice365Source.withAdditionalProperties(additionalProperties);
            return deserializedOffice365Source;
        });
    }
}

