/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ODataSource
extends CopySource {
    private String type = "ODataSource";
    private Object query;
    private Object httpRequestTimeout;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public ODataSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object httpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public ODataSource withHttpRequestTimeout(Object httpRequestTimeout) {
        this.httpRequestTimeout = httpRequestTimeout;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public ODataSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public ODataSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public ODataSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public ODataSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public ODataSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("query", this.query);
        jsonWriter.writeUntypedField("httpRequestTimeout", this.httpRequestTimeout);
        jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ODataSource fromJson(JsonReader jsonReader) throws IOException {
        return (ODataSource)jsonReader.readObject(reader -> {
            ODataSource deserializedODataSource = new ODataSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedODataSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedODataSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedODataSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedODataSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedODataSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedODataSource.query = reader.readUntyped();
                    continue;
                }
                if ("httpRequestTimeout".equals(fieldName)) {
                    deserializedODataSource.httpRequestTimeout = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedODataSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedODataSource.withAdditionalProperties(additionalProperties);
            return deserializedODataSource;
        });
    }
}

