/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.FrequencyType;
import java.io.IOException;

public final class MapperPolicyRecurrence
implements JsonSerializable<MapperPolicyRecurrence> {
    private FrequencyType frequency;
    private Integer interval;

    public FrequencyType frequency() {
        return this.frequency;
    }

    public MapperPolicyRecurrence withFrequency(FrequencyType frequency) {
        this.frequency = frequency;
        return this;
    }

    public Integer interval() {
        return this.interval;
    }

    public MapperPolicyRecurrence withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeNumberField("interval", (Number)this.interval);
        return jsonWriter.writeEndObject();
    }

    public static MapperPolicyRecurrence fromJson(JsonReader jsonReader) throws IOException {
        return (MapperPolicyRecurrence)jsonReader.readObject(reader -> {
            MapperPolicyRecurrence deserializedMapperPolicyRecurrence = new MapperPolicyRecurrence();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frequency".equals(fieldName)) {
                    deserializedMapperPolicyRecurrence.frequency = FrequencyType.fromString(reader.getString());
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedMapperPolicyRecurrence.interval = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapperPolicyRecurrence;
        });
    }
}

