/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.MapperConnectionReference;
import java.io.IOException;

public final class MapperAttributeReference
implements JsonSerializable<MapperAttributeReference> {
    private String name;
    private String entity;
    private MapperConnectionReference entityConnectionReference;

    public String name() {
        return this.name;
    }

    public MapperAttributeReference withName(String name) {
        this.name = name;
        return this;
    }

    public String entity() {
        return this.entity;
    }

    public MapperAttributeReference withEntity(String entity) {
        this.entity = entity;
        return this;
    }

    public MapperConnectionReference entityConnectionReference() {
        return this.entityConnectionReference;
    }

    public MapperAttributeReference withEntityConnectionReference(MapperConnectionReference entityConnectionReference) {
        this.entityConnectionReference = entityConnectionReference;
        return this;
    }

    public void validate() {
        if (this.entityConnectionReference() != null) {
            this.entityConnectionReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("entity", this.entity);
        jsonWriter.writeJsonField("entityConnectionReference", (JsonSerializable)this.entityConnectionReference);
        return jsonWriter.writeEndObject();
    }

    public static MapperAttributeReference fromJson(JsonReader jsonReader) throws IOException {
        return (MapperAttributeReference)jsonReader.readObject(reader -> {
            MapperAttributeReference deserializedMapperAttributeReference = new MapperAttributeReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMapperAttributeReference.name = reader.getString();
                    continue;
                }
                if ("entity".equals(fieldName)) {
                    deserializedMapperAttributeReference.entity = reader.getString();
                    continue;
                }
                if ("entityConnectionReference".equals(fieldName)) {
                    deserializedMapperAttributeReference.entityConnectionReference = MapperConnectionReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapperAttributeReference;
        });
    }
}

