/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedIntegrationRuntimeTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntime;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeComputeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeCustomerVirtualNetwork;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeSsisProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeState;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeType;
import com.azure.resourcemanager.datafactory.models.ManagedVirtualNetworkReference;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ManagedIntegrationRuntime
extends IntegrationRuntime {
    private IntegrationRuntimeType type = IntegrationRuntimeType.MANAGED;
    private IntegrationRuntimeState state;
    private ManagedIntegrationRuntimeTypeProperties innerTypeProperties = new ManagedIntegrationRuntimeTypeProperties();
    private ManagedVirtualNetworkReference managedVirtualNetwork;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedIntegrationRuntime.class);

    @Override
    public IntegrationRuntimeType type() {
        return this.type;
    }

    public IntegrationRuntimeState state() {
        return this.state;
    }

    ManagedIntegrationRuntimeTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public ManagedVirtualNetworkReference managedVirtualNetwork() {
        return this.managedVirtualNetwork;
    }

    public ManagedIntegrationRuntime withManagedVirtualNetwork(ManagedVirtualNetworkReference managedVirtualNetwork) {
        this.managedVirtualNetwork = managedVirtualNetwork;
        return this;
    }

    @Override
    public ManagedIntegrationRuntime withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    public IntegrationRuntimeComputeProperties computeProperties() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().computeProperties();
    }

    public ManagedIntegrationRuntime withComputeProperties(IntegrationRuntimeComputeProperties computeProperties) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ManagedIntegrationRuntimeTypeProperties();
        }
        this.innerTypeProperties().withComputeProperties(computeProperties);
        return this;
    }

    public IntegrationRuntimeSsisProperties ssisProperties() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().ssisProperties();
    }

    public ManagedIntegrationRuntime withSsisProperties(IntegrationRuntimeSsisProperties ssisProperties) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ManagedIntegrationRuntimeTypeProperties();
        }
        this.innerTypeProperties().withSsisProperties(ssisProperties);
        return this;
    }

    public IntegrationRuntimeCustomerVirtualNetwork customerVirtualNetwork() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().customerVirtualNetwork();
    }

    public ManagedIntegrationRuntime withCustomerVirtualNetwork(IntegrationRuntimeCustomerVirtualNetwork customerVirtualNetwork) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ManagedIntegrationRuntimeTypeProperties();
        }
        this.innerTypeProperties().withCustomerVirtualNetwork(customerVirtualNetwork);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ManagedIntegrationRuntime"));
        }
        this.innerTypeProperties().validate();
        if (this.managedVirtualNetwork() != null) {
            this.managedVirtualNetwork().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("managedVirtualNetwork", (JsonSerializable)this.managedVirtualNetwork);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ManagedIntegrationRuntime fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedIntegrationRuntime)jsonReader.readObject(reader -> {
            ManagedIntegrationRuntime deserializedManagedIntegrationRuntime = new ManagedIntegrationRuntime();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedManagedIntegrationRuntime.withDescription(reader.getString());
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedManagedIntegrationRuntime.innerTypeProperties = ManagedIntegrationRuntimeTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedIntegrationRuntime.type = IntegrationRuntimeType.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedManagedIntegrationRuntime.state = IntegrationRuntimeState.fromString(reader.getString());
                    continue;
                }
                if ("managedVirtualNetwork".equals(fieldName)) {
                    deserializedManagedIntegrationRuntime.managedVirtualNetwork = ManagedVirtualNetworkReference.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedManagedIntegrationRuntime.withAdditionalProperties(additionalProperties);
            return deserializedManagedIntegrationRuntime;
        });
    }
}

