/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JsonFormat
extends DatasetStorageFormat {
    private String type = "JsonFormat";
    private Object filePattern;
    private Object nestingSeparator;
    private Object encodingName;
    private Object jsonNodeReference;
    private Object jsonPathDefinition;

    @Override
    public String type() {
        return this.type;
    }

    public Object filePattern() {
        return this.filePattern;
    }

    public JsonFormat withFilePattern(Object filePattern) {
        this.filePattern = filePattern;
        return this;
    }

    public Object nestingSeparator() {
        return this.nestingSeparator;
    }

    public JsonFormat withNestingSeparator(Object nestingSeparator) {
        this.nestingSeparator = nestingSeparator;
        return this;
    }

    public Object encodingName() {
        return this.encodingName;
    }

    public JsonFormat withEncodingName(Object encodingName) {
        this.encodingName = encodingName;
        return this;
    }

    public Object jsonNodeReference() {
        return this.jsonNodeReference;
    }

    public JsonFormat withJsonNodeReference(Object jsonNodeReference) {
        this.jsonNodeReference = jsonNodeReference;
        return this;
    }

    public Object jsonPathDefinition() {
        return this.jsonPathDefinition;
    }

    public JsonFormat withJsonPathDefinition(Object jsonPathDefinition) {
        this.jsonPathDefinition = jsonPathDefinition;
        return this;
    }

    @Override
    public JsonFormat withSerializer(Object serializer) {
        super.withSerializer(serializer);
        return this;
    }

    @Override
    public JsonFormat withDeserializer(Object deserializer) {
        super.withDeserializer(deserializer);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("serializer", this.serializer());
        jsonWriter.writeUntypedField("deserializer", this.deserializer());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("filePattern", this.filePattern);
        jsonWriter.writeUntypedField("nestingSeparator", this.nestingSeparator);
        jsonWriter.writeUntypedField("encodingName", this.encodingName);
        jsonWriter.writeUntypedField("jsonNodeReference", this.jsonNodeReference);
        jsonWriter.writeUntypedField("jsonPathDefinition", this.jsonPathDefinition);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static JsonFormat fromJson(JsonReader jsonReader) throws IOException {
        return (JsonFormat)jsonReader.readObject(reader -> {
            JsonFormat deserializedJsonFormat = new JsonFormat();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serializer".equals(fieldName)) {
                    deserializedJsonFormat.withSerializer(reader.readUntyped());
                    continue;
                }
                if ("deserializer".equals(fieldName)) {
                    deserializedJsonFormat.withDeserializer(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJsonFormat.type = reader.getString();
                    continue;
                }
                if ("filePattern".equals(fieldName)) {
                    deserializedJsonFormat.filePattern = reader.readUntyped();
                    continue;
                }
                if ("nestingSeparator".equals(fieldName)) {
                    deserializedJsonFormat.nestingSeparator = reader.readUntyped();
                    continue;
                }
                if ("encodingName".equals(fieldName)) {
                    deserializedJsonFormat.encodingName = reader.readUntyped();
                    continue;
                }
                if ("jsonNodeReference".equals(fieldName)) {
                    deserializedJsonFormat.jsonNodeReference = reader.readUntyped();
                    continue;
                }
                if ("jsonPathDefinition".equals(fieldName)) {
                    deserializedJsonFormat.jsonPathDefinition = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedJsonFormat.withAdditionalProperties(additionalProperties);
            return deserializedJsonFormat;
        });
    }
}

