/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntime;
import com.azure.resourcemanager.datafactory.models.SubResourceDebugResource;
import java.io.IOException;

public final class IntegrationRuntimeDebugResource
extends SubResourceDebugResource {
    private IntegrationRuntime properties;
    private static final ClientLogger LOGGER = new ClientLogger(IntegrationRuntimeDebugResource.class);

    public IntegrationRuntime properties() {
        return this.properties;
    }

    public IntegrationRuntimeDebugResource withProperties(IntegrationRuntime properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public IntegrationRuntimeDebugResource withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model IntegrationRuntimeDebugResource"));
        }
        this.properties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeDebugResource fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeDebugResource)jsonReader.readObject(reader -> {
            IntegrationRuntimeDebugResource deserializedIntegrationRuntimeDebugResource = new IntegrationRuntimeDebugResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIntegrationRuntimeDebugResource.withName(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIntegrationRuntimeDebugResource.properties = IntegrationRuntime.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIntegrationRuntimeDebugResource;
        });
    }
}

