/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class HttpServerLocation
extends DatasetLocation {
    private String type = "HttpServerLocation";
    private Object relativeUrl;

    @Override
    public String type() {
        return this.type;
    }

    public Object relativeUrl() {
        return this.relativeUrl;
    }

    public HttpServerLocation withRelativeUrl(Object relativeUrl) {
        this.relativeUrl = relativeUrl;
        return this;
    }

    @Override
    public HttpServerLocation withFolderPath(Object folderPath) {
        super.withFolderPath(folderPath);
        return this;
    }

    @Override
    public HttpServerLocation withFileName(Object fileName) {
        super.withFileName(fileName);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("folderPath", this.folderPath());
        jsonWriter.writeUntypedField("fileName", this.fileName());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("relativeUrl", this.relativeUrl);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HttpServerLocation fromJson(JsonReader jsonReader) throws IOException {
        return (HttpServerLocation)jsonReader.readObject(reader -> {
            HttpServerLocation deserializedHttpServerLocation = new HttpServerLocation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedHttpServerLocation.withFolderPath(reader.readUntyped());
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedHttpServerLocation.withFileName(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHttpServerLocation.type = reader.getString();
                    continue;
                }
                if ("relativeUrl".equals(fieldName)) {
                    deserializedHttpServerLocation.relativeUrl = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHttpServerLocation.withAdditionalProperties(additionalProperties);
            return deserializedHttpServerLocation;
        });
    }
}

