/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DistcpSettings;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class HdfsReadSettings
extends StoreReadSettings {
    private String type = "HdfsReadSettings";
    private Object recursive;
    private Object wildcardFolderPath;
    private Object wildcardFileName;
    private Object fileListPath;
    private Object enablePartitionDiscovery;
    private Object partitionRootPath;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;
    private DistcpSettings distcpSettings;
    private Object deleteFilesAfterCompletion;

    @Override
    public String type() {
        return this.type;
    }

    public Object recursive() {
        return this.recursive;
    }

    public HdfsReadSettings withRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    public Object wildcardFolderPath() {
        return this.wildcardFolderPath;
    }

    public HdfsReadSettings withWildcardFolderPath(Object wildcardFolderPath) {
        this.wildcardFolderPath = wildcardFolderPath;
        return this;
    }

    public Object wildcardFileName() {
        return this.wildcardFileName;
    }

    public HdfsReadSettings withWildcardFileName(Object wildcardFileName) {
        this.wildcardFileName = wildcardFileName;
        return this;
    }

    public Object fileListPath() {
        return this.fileListPath;
    }

    public HdfsReadSettings withFileListPath(Object fileListPath) {
        this.fileListPath = fileListPath;
        return this;
    }

    public Object enablePartitionDiscovery() {
        return this.enablePartitionDiscovery;
    }

    public HdfsReadSettings withEnablePartitionDiscovery(Object enablePartitionDiscovery) {
        this.enablePartitionDiscovery = enablePartitionDiscovery;
        return this;
    }

    public Object partitionRootPath() {
        return this.partitionRootPath;
    }

    public HdfsReadSettings withPartitionRootPath(Object partitionRootPath) {
        this.partitionRootPath = partitionRootPath;
        return this;
    }

    public Object modifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public HdfsReadSettings withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object modifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public HdfsReadSettings withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    public DistcpSettings distcpSettings() {
        return this.distcpSettings;
    }

    public HdfsReadSettings withDistcpSettings(DistcpSettings distcpSettings) {
        this.distcpSettings = distcpSettings;
        return this;
    }

    public Object deleteFilesAfterCompletion() {
        return this.deleteFilesAfterCompletion;
    }

    public HdfsReadSettings withDeleteFilesAfterCompletion(Object deleteFilesAfterCompletion) {
        this.deleteFilesAfterCompletion = deleteFilesAfterCompletion;
        return this;
    }

    @Override
    public HdfsReadSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public HdfsReadSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.distcpSettings() != null) {
            this.distcpSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("recursive", this.recursive);
        jsonWriter.writeUntypedField("wildcardFolderPath", this.wildcardFolderPath);
        jsonWriter.writeUntypedField("wildcardFileName", this.wildcardFileName);
        jsonWriter.writeUntypedField("fileListPath", this.fileListPath);
        jsonWriter.writeUntypedField("enablePartitionDiscovery", this.enablePartitionDiscovery);
        jsonWriter.writeUntypedField("partitionRootPath", this.partitionRootPath);
        jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
        jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
        jsonWriter.writeJsonField("distcpSettings", (JsonSerializable)this.distcpSettings);
        jsonWriter.writeUntypedField("deleteFilesAfterCompletion", this.deleteFilesAfterCompletion);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HdfsReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (HdfsReadSettings)jsonReader.readObject(reader -> {
            HdfsReadSettings deserializedHdfsReadSettings = new HdfsReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedHdfsReadSettings.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedHdfsReadSettings.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHdfsReadSettings.type = reader.getString();
                    continue;
                }
                if ("recursive".equals(fieldName)) {
                    deserializedHdfsReadSettings.recursive = reader.readUntyped();
                    continue;
                }
                if ("wildcardFolderPath".equals(fieldName)) {
                    deserializedHdfsReadSettings.wildcardFolderPath = reader.readUntyped();
                    continue;
                }
                if ("wildcardFileName".equals(fieldName)) {
                    deserializedHdfsReadSettings.wildcardFileName = reader.readUntyped();
                    continue;
                }
                if ("fileListPath".equals(fieldName)) {
                    deserializedHdfsReadSettings.fileListPath = reader.readUntyped();
                    continue;
                }
                if ("enablePartitionDiscovery".equals(fieldName)) {
                    deserializedHdfsReadSettings.enablePartitionDiscovery = reader.readUntyped();
                    continue;
                }
                if ("partitionRootPath".equals(fieldName)) {
                    deserializedHdfsReadSettings.partitionRootPath = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeStart".equals(fieldName)) {
                    deserializedHdfsReadSettings.modifiedDatetimeStart = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeEnd".equals(fieldName)) {
                    deserializedHdfsReadSettings.modifiedDatetimeEnd = reader.readUntyped();
                    continue;
                }
                if ("distcpSettings".equals(fieldName)) {
                    deserializedHdfsReadSettings.distcpSettings = DistcpSettings.fromJson(reader);
                    continue;
                }
                if ("deleteFilesAfterCompletion".equals(fieldName)) {
                    deserializedHdfsReadSettings.deleteFilesAfterCompletion = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHdfsReadSettings.withAdditionalProperties(additionalProperties);
            return deserializedHdfsReadSettings;
        });
    }
}

