/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.BinaryReadSettings;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BinarySource
extends CopySource {
    private String type = "BinarySource";
    private StoreReadSettings storeSettings;
    private BinaryReadSettings formatSettings;

    @Override
    public String type() {
        return this.type;
    }

    public StoreReadSettings storeSettings() {
        return this.storeSettings;
    }

    public BinarySource withStoreSettings(StoreReadSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    public BinaryReadSettings formatSettings() {
        return this.formatSettings;
    }

    public BinarySource withFormatSettings(BinaryReadSettings formatSettings) {
        this.formatSettings = formatSettings;
        return this;
    }

    @Override
    public BinarySource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public BinarySource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public BinarySource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public BinarySource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.storeSettings() != null) {
            this.storeSettings().validate();
        }
        if (this.formatSettings() != null) {
            this.formatSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("storeSettings", (JsonSerializable)this.storeSettings);
        jsonWriter.writeJsonField("formatSettings", (JsonSerializable)this.formatSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static BinarySource fromJson(JsonReader jsonReader) throws IOException {
        return (BinarySource)jsonReader.readObject(reader -> {
            BinarySource deserializedBinarySource = new BinarySource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedBinarySource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedBinarySource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedBinarySource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedBinarySource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBinarySource.type = reader.getString();
                    continue;
                }
                if ("storeSettings".equals(fieldName)) {
                    deserializedBinarySource.storeSettings = StoreReadSettings.fromJson(reader);
                    continue;
                }
                if ("formatSettings".equals(fieldName)) {
                    deserializedBinarySource.formatSettings = BinaryReadSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedBinarySource.withAdditionalProperties(additionalProperties);
            return deserializedBinarySource;
        });
    }
}

