/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureDatabricksDeltaLakeExportCommand;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureDatabricksDeltaLakeSource
extends CopySource {
    private String type = "AzureDatabricksDeltaLakeSource";
    private Object query;
    private AzureDatabricksDeltaLakeExportCommand exportSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public AzureDatabricksDeltaLakeSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    public AzureDatabricksDeltaLakeExportCommand exportSettings() {
        return this.exportSettings;
    }

    public AzureDatabricksDeltaLakeSource withExportSettings(AzureDatabricksDeltaLakeExportCommand exportSettings) {
        this.exportSettings = exportSettings;
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.exportSettings() != null) {
            this.exportSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("query", this.query);
        jsonWriter.writeJsonField("exportSettings", (JsonSerializable)this.exportSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksDeltaLakeSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksDeltaLakeSource)jsonReader.readObject(reader -> {
            AzureDatabricksDeltaLakeSource deserializedAzureDatabricksDeltaLakeSource = new AzureDatabricksDeltaLakeSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.query = reader.readUntyped();
                    continue;
                }
                if ("exportSettings".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.exportSettings = AzureDatabricksDeltaLakeExportCommand.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDatabricksDeltaLakeSource.withAdditionalProperties(additionalProperties);
            return deserializedAzureDatabricksDeltaLakeSource;
        });
    }
}

