/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AvroDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AvroDataset
extends Dataset {
    private String type = "Avro";
    private AvroDatasetTypeProperties innerTypeProperties;
    private static final ClientLogger LOGGER = new ClientLogger(AvroDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    AvroDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AvroDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AvroDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public AvroDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public AvroDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AvroDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AvroDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public AvroDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public DatasetLocation location() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().location();
    }

    public AvroDataset withLocation(DatasetLocation location) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AvroDatasetTypeProperties();
        }
        this.innerTypeProperties().withLocation(location);
        return this;
    }

    public Object avroCompressionCodec() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().avroCompressionCodec();
    }

    public AvroDataset withAvroCompressionCodec(Object avroCompressionCodec) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AvroDatasetTypeProperties();
        }
        this.innerTypeProperties().withAvroCompressionCodec(avroCompressionCodec);
        return this;
    }

    public Integer avroCompressionLevel() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().avroCompressionLevel();
    }

    public AvroDataset withAvroCompressionLevel(Integer avroCompressionLevel) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AvroDatasetTypeProperties();
        }
        this.innerTypeProperties().withAvroCompressionLevel(avroCompressionLevel);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model AvroDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeUntypedField("structure", this.structure());
        jsonWriter.writeUntypedField("schema", this.schema());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AvroDataset fromJson(JsonReader jsonReader) throws IOException {
        return (AvroDataset)jsonReader.readObject(reader -> {
            AvroDataset deserializedAvroDataset = new AvroDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAvroDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAvroDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedAvroDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedAvroDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAvroDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAvroDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedAvroDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAvroDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAvroDataset.innerTypeProperties = AvroDatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAvroDataset.withAdditionalProperties(additionalProperties);
            return deserializedAvroDataset;
        });
    }
}

