/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AmazonS3Location
extends DatasetLocation {
    private String type = "AmazonS3Location";
    private Object bucketName;
    private Object version;

    @Override
    public String type() {
        return this.type;
    }

    public Object bucketName() {
        return this.bucketName;
    }

    public AmazonS3Location withBucketName(Object bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public Object version() {
        return this.version;
    }

    public AmazonS3Location withVersion(Object version) {
        this.version = version;
        return this;
    }

    @Override
    public AmazonS3Location withFolderPath(Object folderPath) {
        super.withFolderPath(folderPath);
        return this;
    }

    @Override
    public AmazonS3Location withFileName(Object fileName) {
        super.withFileName(fileName);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("folderPath", this.folderPath());
        jsonWriter.writeUntypedField("fileName", this.fileName());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("bucketName", this.bucketName);
        jsonWriter.writeUntypedField("version", this.version);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonS3Location fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonS3Location)jsonReader.readObject(reader -> {
            AmazonS3Location deserializedAmazonS3Location = new AmazonS3Location();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedAmazonS3Location.withFolderPath(reader.readUntyped());
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedAmazonS3Location.withFileName(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonS3Location.type = reader.getString();
                    continue;
                }
                if ("bucketName".equals(fieldName)) {
                    deserializedAmazonS3Location.bucketName = reader.readUntyped();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAmazonS3Location.version = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonS3Location.withAdditionalProperties(additionalProperties);
            return deserializedAmazonS3Location;
        });
    }
}

