/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AmazonRdsForOracleTableDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AmazonRdsForOracleTableDataset
extends Dataset {
    private String type = "AmazonRdsForOracleTable";
    private AmazonRdsForOracleTableDatasetTypeProperties innerTypeProperties;
    private static final ClientLogger LOGGER = new ClientLogger(AmazonRdsForOracleTableDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    AmazonRdsForOracleTableDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AmazonRdsForOracleTableDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AmazonRdsForOracleTableDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public AmazonRdsForOracleTableDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public AmazonRdsForOracleTableDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AmazonRdsForOracleTableDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AmazonRdsForOracleTableDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public AmazonRdsForOracleTableDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object schemaTypePropertiesSchema() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().schema();
    }

    public AmazonRdsForOracleTableDataset withSchemaTypePropertiesSchema(Object schema) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForOracleTableDatasetTypeProperties();
        }
        this.innerTypeProperties().withSchema(schema);
        return this;
    }

    public Object table() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().table();
    }

    public AmazonRdsForOracleTableDataset withTable(Object table) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForOracleTableDatasetTypeProperties();
        }
        this.innerTypeProperties().withTable(table);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model AmazonRdsForOracleTableDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeUntypedField("structure", this.structure());
        jsonWriter.writeUntypedField("schema", this.schema());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonRdsForOracleTableDataset fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRdsForOracleTableDataset)jsonReader.readObject(reader -> {
            AmazonRdsForOracleTableDataset deserializedAmazonRdsForOracleTableDataset = new AmazonRdsForOracleTableDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAmazonRdsForOracleTableDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAmazonRdsForOracleTableDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedAmazonRdsForOracleTableDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedAmazonRdsForOracleTableDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAmazonRdsForOracleTableDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAmazonRdsForOracleTableDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedAmazonRdsForOracleTableDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonRdsForOracleTableDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAmazonRdsForOracleTableDataset.innerTypeProperties = AmazonRdsForOracleTableDatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonRdsForOracleTableDataset.withAdditionalProperties(additionalProperties);
            return deserializedAmazonRdsForOracleTableDataset;
        });
    }
}

