/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class XeroLinkedServiceTypeProperties
implements JsonSerializable<XeroLinkedServiceTypeProperties> {
    private Object connectionProperties;
    private Object host;
    private SecretBase consumerKey;
    private SecretBase privateKey;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private String encryptedCredential;

    public Object connectionProperties() {
        return this.connectionProperties;
    }

    public XeroLinkedServiceTypeProperties withConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public Object host() {
        return this.host;
    }

    public XeroLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public SecretBase consumerKey() {
        return this.consumerKey;
    }

    public XeroLinkedServiceTypeProperties withConsumerKey(SecretBase consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    public SecretBase privateKey() {
        return this.privateKey;
    }

    public XeroLinkedServiceTypeProperties withPrivateKey(SecretBase privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public XeroLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object useHostVerification() {
        return this.useHostVerification;
    }

    public XeroLinkedServiceTypeProperties withUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object usePeerVerification() {
        return this.usePeerVerification;
    }

    public XeroLinkedServiceTypeProperties withUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public XeroLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.consumerKey() != null) {
            this.consumerKey().validate();
        }
        if (this.privateKey() != null) {
            this.privateKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionProperties", this.connectionProperties);
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeJsonField("consumerKey", (JsonSerializable)this.consumerKey);
        jsonWriter.writeJsonField("privateKey", (JsonSerializable)this.privateKey);
        jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
        jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
        jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static XeroLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (XeroLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            XeroLinkedServiceTypeProperties deserializedXeroLinkedServiceTypeProperties = new XeroLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionProperties".equals(fieldName)) {
                    deserializedXeroLinkedServiceTypeProperties.connectionProperties = reader.readUntyped();
                    continue;
                }
                if ("host".equals(fieldName)) {
                    deserializedXeroLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("consumerKey".equals(fieldName)) {
                    deserializedXeroLinkedServiceTypeProperties.consumerKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("privateKey".equals(fieldName)) {
                    deserializedXeroLinkedServiceTypeProperties.privateKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("useEncryptedEndpoints".equals(fieldName)) {
                    deserializedXeroLinkedServiceTypeProperties.useEncryptedEndpoints = reader.readUntyped();
                    continue;
                }
                if ("useHostVerification".equals(fieldName)) {
                    deserializedXeroLinkedServiceTypeProperties.useHostVerification = reader.readUntyped();
                    continue;
                }
                if ("usePeerVerification".equals(fieldName)) {
                    deserializedXeroLinkedServiceTypeProperties.usePeerVerification = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedXeroLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedXeroLinkedServiceTypeProperties;
        });
    }
}

