/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DependencyReference;
import com.azure.resourcemanager.datafactory.models.RetryPolicy;
import com.azure.resourcemanager.datafactory.models.TumblingWindowFrequency;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class TumblingWindowTriggerTypeProperties
implements JsonSerializable<TumblingWindowTriggerTypeProperties> {
    private TumblingWindowFrequency frequency;
    private int interval;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Object delay;
    private int maxConcurrency;
    private RetryPolicy retryPolicy;
    private List<DependencyReference> dependsOn;
    private static final ClientLogger LOGGER = new ClientLogger(TumblingWindowTriggerTypeProperties.class);

    public TumblingWindowFrequency frequency() {
        return this.frequency;
    }

    public TumblingWindowTriggerTypeProperties withFrequency(TumblingWindowFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public int interval() {
        return this.interval;
    }

    public TumblingWindowTriggerTypeProperties withInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public TumblingWindowTriggerTypeProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public TumblingWindowTriggerTypeProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public Object delay() {
        return this.delay;
    }

    public TumblingWindowTriggerTypeProperties withDelay(Object delay) {
        this.delay = delay;
        return this;
    }

    public int maxConcurrency() {
        return this.maxConcurrency;
    }

    public TumblingWindowTriggerTypeProperties withMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public TumblingWindowTriggerTypeProperties withRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public List<DependencyReference> dependsOn() {
        return this.dependsOn;
    }

    public TumblingWindowTriggerTypeProperties withDependsOn(List<DependencyReference> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public void validate() {
        if (this.frequency() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property frequency in model TumblingWindowTriggerTypeProperties"));
        }
        if (this.startTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startTime in model TumblingWindowTriggerTypeProperties"));
        }
        if (this.retryPolicy() != null) {
            this.retryPolicy().validate();
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeIntField("interval", this.interval);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeIntField("maxConcurrency", this.maxConcurrency);
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeUntypedField("delay", this.delay);
        jsonWriter.writeJsonField("retryPolicy", (JsonSerializable)this.retryPolicy);
        jsonWriter.writeArrayField("dependsOn", this.dependsOn, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TumblingWindowTriggerTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TumblingWindowTriggerTypeProperties)jsonReader.readObject(reader -> {
            TumblingWindowTriggerTypeProperties deserializedTumblingWindowTriggerTypeProperties = new TumblingWindowTriggerTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frequency".equals(fieldName)) {
                    deserializedTumblingWindowTriggerTypeProperties.frequency = TumblingWindowFrequency.fromString(reader.getString());
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedTumblingWindowTriggerTypeProperties.interval = reader.getInt();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedTumblingWindowTriggerTypeProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("maxConcurrency".equals(fieldName)) {
                    deserializedTumblingWindowTriggerTypeProperties.maxConcurrency = reader.getInt();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedTumblingWindowTriggerTypeProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("delay".equals(fieldName)) {
                    deserializedTumblingWindowTriggerTypeProperties.delay = reader.readUntyped();
                    continue;
                }
                if ("retryPolicy".equals(fieldName)) {
                    deserializedTumblingWindowTriggerTypeProperties.retryPolicy = RetryPolicy.fromJson(reader);
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn;
                    deserializedTumblingWindowTriggerTypeProperties.dependsOn = dependsOn = reader.readArray(reader1 -> DependencyReference.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTumblingWindowTriggerTypeProperties;
        });
    }
}

