/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.BigDataPoolParametrizationReference;
import com.azure.resourcemanager.datafactory.models.ConfigurationType;
import com.azure.resourcemanager.datafactory.models.SparkConfigurationParametrizationReference;
import com.azure.resourcemanager.datafactory.models.SynapseSparkJobReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SynapseSparkJobActivityTypeProperties
implements JsonSerializable<SynapseSparkJobActivityTypeProperties> {
    private SynapseSparkJobReference sparkJob;
    private List<Object> arguments;
    private Object file;
    private Object scanFolder;
    private Object className;
    private List<Object> files;
    private List<Object> pythonCodeReference;
    private List<Object> filesV2;
    private BigDataPoolParametrizationReference targetBigDataPool;
    private Object executorSize;
    private Object conf;
    private Object driverSize;
    private Object numExecutors;
    private ConfigurationType configurationType;
    private SparkConfigurationParametrizationReference targetSparkConfiguration;
    private Map<String, Object> sparkConfig;
    private static final ClientLogger LOGGER = new ClientLogger(SynapseSparkJobActivityTypeProperties.class);

    public SynapseSparkJobReference sparkJob() {
        return this.sparkJob;
    }

    public SynapseSparkJobActivityTypeProperties withSparkJob(SynapseSparkJobReference sparkJob) {
        this.sparkJob = sparkJob;
        return this;
    }

    public List<Object> arguments() {
        return this.arguments;
    }

    public SynapseSparkJobActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public Object file() {
        return this.file;
    }

    public SynapseSparkJobActivityTypeProperties withFile(Object file) {
        this.file = file;
        return this;
    }

    public Object scanFolder() {
        return this.scanFolder;
    }

    public SynapseSparkJobActivityTypeProperties withScanFolder(Object scanFolder) {
        this.scanFolder = scanFolder;
        return this;
    }

    public Object className() {
        return this.className;
    }

    public SynapseSparkJobActivityTypeProperties withClassName(Object className) {
        this.className = className;
        return this;
    }

    public List<Object> files() {
        return this.files;
    }

    public SynapseSparkJobActivityTypeProperties withFiles(List<Object> files) {
        this.files = files;
        return this;
    }

    public List<Object> pythonCodeReference() {
        return this.pythonCodeReference;
    }

    public SynapseSparkJobActivityTypeProperties withPythonCodeReference(List<Object> pythonCodeReference) {
        this.pythonCodeReference = pythonCodeReference;
        return this;
    }

    public List<Object> filesV2() {
        return this.filesV2;
    }

    public SynapseSparkJobActivityTypeProperties withFilesV2(List<Object> filesV2) {
        this.filesV2 = filesV2;
        return this;
    }

    public BigDataPoolParametrizationReference targetBigDataPool() {
        return this.targetBigDataPool;
    }

    public SynapseSparkJobActivityTypeProperties withTargetBigDataPool(BigDataPoolParametrizationReference targetBigDataPool) {
        this.targetBigDataPool = targetBigDataPool;
        return this;
    }

    public Object executorSize() {
        return this.executorSize;
    }

    public SynapseSparkJobActivityTypeProperties withExecutorSize(Object executorSize) {
        this.executorSize = executorSize;
        return this;
    }

    public Object conf() {
        return this.conf;
    }

    public SynapseSparkJobActivityTypeProperties withConf(Object conf) {
        this.conf = conf;
        return this;
    }

    public Object driverSize() {
        return this.driverSize;
    }

    public SynapseSparkJobActivityTypeProperties withDriverSize(Object driverSize) {
        this.driverSize = driverSize;
        return this;
    }

    public Object numExecutors() {
        return this.numExecutors;
    }

    public SynapseSparkJobActivityTypeProperties withNumExecutors(Object numExecutors) {
        this.numExecutors = numExecutors;
        return this;
    }

    public ConfigurationType configurationType() {
        return this.configurationType;
    }

    public SynapseSparkJobActivityTypeProperties withConfigurationType(ConfigurationType configurationType) {
        this.configurationType = configurationType;
        return this;
    }

    public SparkConfigurationParametrizationReference targetSparkConfiguration() {
        return this.targetSparkConfiguration;
    }

    public SynapseSparkJobActivityTypeProperties withTargetSparkConfiguration(SparkConfigurationParametrizationReference targetSparkConfiguration) {
        this.targetSparkConfiguration = targetSparkConfiguration;
        return this;
    }

    public Map<String, Object> sparkConfig() {
        return this.sparkConfig;
    }

    public SynapseSparkJobActivityTypeProperties withSparkConfig(Map<String, Object> sparkConfig) {
        this.sparkConfig = sparkConfig;
        return this;
    }

    public void validate() {
        if (this.sparkJob() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sparkJob in model SynapseSparkJobActivityTypeProperties"));
        }
        this.sparkJob().validate();
        if (this.targetBigDataPool() != null) {
            this.targetBigDataPool().validate();
        }
        if (this.targetSparkConfiguration() != null) {
            this.targetSparkConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sparkJob", (JsonSerializable)this.sparkJob);
        jsonWriter.writeArrayField("args", this.arguments, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeUntypedField("file", this.file);
        jsonWriter.writeUntypedField("scanFolder", this.scanFolder);
        jsonWriter.writeUntypedField("className", this.className);
        jsonWriter.writeArrayField("files", this.files, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("pythonCodeReference", this.pythonCodeReference, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("filesV2", this.filesV2, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("targetBigDataPool", (JsonSerializable)this.targetBigDataPool);
        jsonWriter.writeUntypedField("executorSize", this.executorSize);
        jsonWriter.writeUntypedField("conf", this.conf);
        jsonWriter.writeUntypedField("driverSize", this.driverSize);
        jsonWriter.writeUntypedField("numExecutors", this.numExecutors);
        jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
        jsonWriter.writeJsonField("targetSparkConfiguration", (JsonSerializable)this.targetSparkConfiguration);
        jsonWriter.writeMapField("sparkConfig", this.sparkConfig, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static SynapseSparkJobActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SynapseSparkJobActivityTypeProperties)jsonReader.readObject(reader -> {
            SynapseSparkJobActivityTypeProperties deserializedSynapseSparkJobActivityTypeProperties = new SynapseSparkJobActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sparkJob".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.sparkJob = SynapseSparkJobReference.fromJson(reader);
                    continue;
                }
                if ("args".equals(fieldName)) {
                    List arguments;
                    deserializedSynapseSparkJobActivityTypeProperties.arguments = arguments = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("file".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.file = reader.readUntyped();
                    continue;
                }
                if ("scanFolder".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.scanFolder = reader.readUntyped();
                    continue;
                }
                if ("className".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.className = reader.readUntyped();
                    continue;
                }
                if ("files".equals(fieldName)) {
                    List files;
                    deserializedSynapseSparkJobActivityTypeProperties.files = files = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("pythonCodeReference".equals(fieldName)) {
                    List pythonCodeReference;
                    deserializedSynapseSparkJobActivityTypeProperties.pythonCodeReference = pythonCodeReference = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("filesV2".equals(fieldName)) {
                    List filesV2;
                    deserializedSynapseSparkJobActivityTypeProperties.filesV2 = filesV2 = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("targetBigDataPool".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.targetBigDataPool = BigDataPoolParametrizationReference.fromJson(reader);
                    continue;
                }
                if ("executorSize".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.executorSize = reader.readUntyped();
                    continue;
                }
                if ("conf".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.conf = reader.readUntyped();
                    continue;
                }
                if ("driverSize".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.driverSize = reader.readUntyped();
                    continue;
                }
                if ("numExecutors".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.numExecutors = reader.readUntyped();
                    continue;
                }
                if ("configurationType".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.configurationType = ConfigurationType.fromString(reader.getString());
                    continue;
                }
                if ("targetSparkConfiguration".equals(fieldName)) {
                    deserializedSynapseSparkJobActivityTypeProperties.targetSparkConfiguration = SparkConfigurationParametrizationReference.fromJson(reader);
                    continue;
                }
                if ("sparkConfig".equals(fieldName)) {
                    Map sparkConfig;
                    deserializedSynapseSparkJobActivityTypeProperties.sparkConfig = sparkConfig = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSynapseSparkJobActivityTypeProperties;
        });
    }
}

