/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.BigDataPoolParametrizationReference;
import com.azure.resourcemanager.datafactory.models.ConfigurationType;
import com.azure.resourcemanager.datafactory.models.NotebookParameter;
import com.azure.resourcemanager.datafactory.models.SparkConfigurationParametrizationReference;
import com.azure.resourcemanager.datafactory.models.SynapseNotebookReference;
import java.io.IOException;
import java.util.Map;

public final class SynapseNotebookActivityTypeProperties
implements JsonSerializable<SynapseNotebookActivityTypeProperties> {
    private SynapseNotebookReference notebook;
    private BigDataPoolParametrizationReference sparkPool;
    private Map<String, NotebookParameter> parameters;
    private Object executorSize;
    private Object conf;
    private Object driverSize;
    private Object numExecutors;
    private ConfigurationType configurationType;
    private SparkConfigurationParametrizationReference targetSparkConfiguration;
    private Map<String, Object> sparkConfig;
    private static final ClientLogger LOGGER = new ClientLogger(SynapseNotebookActivityTypeProperties.class);

    public SynapseNotebookReference notebook() {
        return this.notebook;
    }

    public SynapseNotebookActivityTypeProperties withNotebook(SynapseNotebookReference notebook) {
        this.notebook = notebook;
        return this;
    }

    public BigDataPoolParametrizationReference sparkPool() {
        return this.sparkPool;
    }

    public SynapseNotebookActivityTypeProperties withSparkPool(BigDataPoolParametrizationReference sparkPool) {
        this.sparkPool = sparkPool;
        return this;
    }

    public Map<String, NotebookParameter> parameters() {
        return this.parameters;
    }

    public SynapseNotebookActivityTypeProperties withParameters(Map<String, NotebookParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Object executorSize() {
        return this.executorSize;
    }

    public SynapseNotebookActivityTypeProperties withExecutorSize(Object executorSize) {
        this.executorSize = executorSize;
        return this;
    }

    public Object conf() {
        return this.conf;
    }

    public SynapseNotebookActivityTypeProperties withConf(Object conf) {
        this.conf = conf;
        return this;
    }

    public Object driverSize() {
        return this.driverSize;
    }

    public SynapseNotebookActivityTypeProperties withDriverSize(Object driverSize) {
        this.driverSize = driverSize;
        return this;
    }

    public Object numExecutors() {
        return this.numExecutors;
    }

    public SynapseNotebookActivityTypeProperties withNumExecutors(Object numExecutors) {
        this.numExecutors = numExecutors;
        return this;
    }

    public ConfigurationType configurationType() {
        return this.configurationType;
    }

    public SynapseNotebookActivityTypeProperties withConfigurationType(ConfigurationType configurationType) {
        this.configurationType = configurationType;
        return this;
    }

    public SparkConfigurationParametrizationReference targetSparkConfiguration() {
        return this.targetSparkConfiguration;
    }

    public SynapseNotebookActivityTypeProperties withTargetSparkConfiguration(SparkConfigurationParametrizationReference targetSparkConfiguration) {
        this.targetSparkConfiguration = targetSparkConfiguration;
        return this;
    }

    public Map<String, Object> sparkConfig() {
        return this.sparkConfig;
    }

    public SynapseNotebookActivityTypeProperties withSparkConfig(Map<String, Object> sparkConfig) {
        this.sparkConfig = sparkConfig;
        return this;
    }

    public void validate() {
        if (this.notebook() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property notebook in model SynapseNotebookActivityTypeProperties"));
        }
        this.notebook().validate();
        if (this.sparkPool() != null) {
            this.sparkPool().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.targetSparkConfiguration() != null) {
            this.targetSparkConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("notebook", (JsonSerializable)this.notebook);
        jsonWriter.writeJsonField("sparkPool", (JsonSerializable)this.sparkPool);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeUntypedField("executorSize", this.executorSize);
        jsonWriter.writeUntypedField("conf", this.conf);
        jsonWriter.writeUntypedField("driverSize", this.driverSize);
        jsonWriter.writeUntypedField("numExecutors", this.numExecutors);
        jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
        jsonWriter.writeJsonField("targetSparkConfiguration", (JsonSerializable)this.targetSparkConfiguration);
        jsonWriter.writeMapField("sparkConfig", this.sparkConfig, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static SynapseNotebookActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SynapseNotebookActivityTypeProperties)jsonReader.readObject(reader -> {
            SynapseNotebookActivityTypeProperties deserializedSynapseNotebookActivityTypeProperties = new SynapseNotebookActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("notebook".equals(fieldName)) {
                    deserializedSynapseNotebookActivityTypeProperties.notebook = SynapseNotebookReference.fromJson(reader);
                    continue;
                }
                if ("sparkPool".equals(fieldName)) {
                    deserializedSynapseNotebookActivityTypeProperties.sparkPool = BigDataPoolParametrizationReference.fromJson(reader);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedSynapseNotebookActivityTypeProperties.parameters = parameters = reader.readMap(reader1 -> NotebookParameter.fromJson(reader1));
                    continue;
                }
                if ("executorSize".equals(fieldName)) {
                    deserializedSynapseNotebookActivityTypeProperties.executorSize = reader.readUntyped();
                    continue;
                }
                if ("conf".equals(fieldName)) {
                    deserializedSynapseNotebookActivityTypeProperties.conf = reader.readUntyped();
                    continue;
                }
                if ("driverSize".equals(fieldName)) {
                    deserializedSynapseNotebookActivityTypeProperties.driverSize = reader.readUntyped();
                    continue;
                }
                if ("numExecutors".equals(fieldName)) {
                    deserializedSynapseNotebookActivityTypeProperties.numExecutors = reader.readUntyped();
                    continue;
                }
                if ("configurationType".equals(fieldName)) {
                    deserializedSynapseNotebookActivityTypeProperties.configurationType = ConfigurationType.fromString(reader.getString());
                    continue;
                }
                if ("targetSparkConfiguration".equals(fieldName)) {
                    deserializedSynapseNotebookActivityTypeProperties.targetSparkConfiguration = SparkConfigurationParametrizationReference.fromJson(reader);
                    continue;
                }
                if ("sparkConfig".equals(fieldName)) {
                    Map sparkConfig;
                    deserializedSynapseNotebookActivityTypeProperties.sparkConfig = sparkConfig = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSynapseNotebookActivityTypeProperties;
        });
    }
}

