/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SsisAccessCredential;
import com.azure.resourcemanager.datafactory.models.SsisChildPackage;
import java.io.IOException;
import java.util.List;

public final class SsisPackageLocationTypeProperties
implements JsonSerializable<SsisPackageLocationTypeProperties> {
    private SecretBase packagePassword;
    private SsisAccessCredential accessCredential;
    private Object configurationPath;
    private SsisAccessCredential configurationAccessCredential;
    private String packageName;
    private Object packageContent;
    private String packageLastModifiedDate;
    private List<SsisChildPackage> childPackages;

    public SecretBase packagePassword() {
        return this.packagePassword;
    }

    public SsisPackageLocationTypeProperties withPackagePassword(SecretBase packagePassword) {
        this.packagePassword = packagePassword;
        return this;
    }

    public SsisAccessCredential accessCredential() {
        return this.accessCredential;
    }

    public SsisPackageLocationTypeProperties withAccessCredential(SsisAccessCredential accessCredential) {
        this.accessCredential = accessCredential;
        return this;
    }

    public Object configurationPath() {
        return this.configurationPath;
    }

    public SsisPackageLocationTypeProperties withConfigurationPath(Object configurationPath) {
        this.configurationPath = configurationPath;
        return this;
    }

    public SsisAccessCredential configurationAccessCredential() {
        return this.configurationAccessCredential;
    }

    public SsisPackageLocationTypeProperties withConfigurationAccessCredential(SsisAccessCredential configurationAccessCredential) {
        this.configurationAccessCredential = configurationAccessCredential;
        return this;
    }

    public String packageName() {
        return this.packageName;
    }

    public SsisPackageLocationTypeProperties withPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public Object packageContent() {
        return this.packageContent;
    }

    public SsisPackageLocationTypeProperties withPackageContent(Object packageContent) {
        this.packageContent = packageContent;
        return this;
    }

    public String packageLastModifiedDate() {
        return this.packageLastModifiedDate;
    }

    public SsisPackageLocationTypeProperties withPackageLastModifiedDate(String packageLastModifiedDate) {
        this.packageLastModifiedDate = packageLastModifiedDate;
        return this;
    }

    public List<SsisChildPackage> childPackages() {
        return this.childPackages;
    }

    public SsisPackageLocationTypeProperties withChildPackages(List<SsisChildPackage> childPackages) {
        this.childPackages = childPackages;
        return this;
    }

    public void validate() {
        if (this.packagePassword() != null) {
            this.packagePassword().validate();
        }
        if (this.accessCredential() != null) {
            this.accessCredential().validate();
        }
        if (this.configurationAccessCredential() != null) {
            this.configurationAccessCredential().validate();
        }
        if (this.childPackages() != null) {
            this.childPackages().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("packagePassword", (JsonSerializable)this.packagePassword);
        jsonWriter.writeJsonField("accessCredential", (JsonSerializable)this.accessCredential);
        jsonWriter.writeUntypedField("configurationPath", this.configurationPath);
        jsonWriter.writeJsonField("configurationAccessCredential", (JsonSerializable)this.configurationAccessCredential);
        jsonWriter.writeStringField("packageName", this.packageName);
        jsonWriter.writeUntypedField("packageContent", this.packageContent);
        jsonWriter.writeStringField("packageLastModifiedDate", this.packageLastModifiedDate);
        jsonWriter.writeArrayField("childPackages", this.childPackages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SsisPackageLocationTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SsisPackageLocationTypeProperties)jsonReader.readObject(reader -> {
            SsisPackageLocationTypeProperties deserializedSsisPackageLocationTypeProperties = new SsisPackageLocationTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("packagePassword".equals(fieldName)) {
                    deserializedSsisPackageLocationTypeProperties.packagePassword = SecretBase.fromJson(reader);
                    continue;
                }
                if ("accessCredential".equals(fieldName)) {
                    deserializedSsisPackageLocationTypeProperties.accessCredential = SsisAccessCredential.fromJson(reader);
                    continue;
                }
                if ("configurationPath".equals(fieldName)) {
                    deserializedSsisPackageLocationTypeProperties.configurationPath = reader.readUntyped();
                    continue;
                }
                if ("configurationAccessCredential".equals(fieldName)) {
                    deserializedSsisPackageLocationTypeProperties.configurationAccessCredential = SsisAccessCredential.fromJson(reader);
                    continue;
                }
                if ("packageName".equals(fieldName)) {
                    deserializedSsisPackageLocationTypeProperties.packageName = reader.getString();
                    continue;
                }
                if ("packageContent".equals(fieldName)) {
                    deserializedSsisPackageLocationTypeProperties.packageContent = reader.readUntyped();
                    continue;
                }
                if ("packageLastModifiedDate".equals(fieldName)) {
                    deserializedSsisPackageLocationTypeProperties.packageLastModifiedDate = reader.getString();
                    continue;
                }
                if ("childPackages".equals(fieldName)) {
                    List childPackages;
                    deserializedSsisPackageLocationTypeProperties.childPackages = childPackages = reader.readArray(reader1 -> SsisChildPackage.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisPackageLocationTypeProperties;
        });
    }
}

