/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SparkAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SparkServerType;
import com.azure.resourcemanager.datafactory.models.SparkThriftTransportProtocol;
import java.io.IOException;

public final class SparkLinkedServiceTypeProperties
implements JsonSerializable<SparkLinkedServiceTypeProperties> {
    private Object host;
    private Object port;
    private SparkServerType serverType;
    private SparkThriftTransportProtocol thriftTransportProtocol;
    private SparkAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object httpPath;
    private Object enableSsl;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private Object allowHostnameCNMismatch;
    private Object allowSelfSignedServerCert;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(SparkLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public SparkLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public SparkLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public SparkServerType serverType() {
        return this.serverType;
    }

    public SparkLinkedServiceTypeProperties withServerType(SparkServerType serverType) {
        this.serverType = serverType;
        return this;
    }

    public SparkThriftTransportProtocol thriftTransportProtocol() {
        return this.thriftTransportProtocol;
    }

    public SparkLinkedServiceTypeProperties withThriftTransportProtocol(SparkThriftTransportProtocol thriftTransportProtocol) {
        this.thriftTransportProtocol = thriftTransportProtocol;
        return this;
    }

    public SparkAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public SparkLinkedServiceTypeProperties withAuthenticationType(SparkAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public SparkLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public SparkLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object httpPath() {
        return this.httpPath;
    }

    public SparkLinkedServiceTypeProperties withHttpPath(Object httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    public Object enableSsl() {
        return this.enableSsl;
    }

    public SparkLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    public SparkLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public SparkLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public Object allowHostnameCNMismatch() {
        return this.allowHostnameCNMismatch;
    }

    public SparkLinkedServiceTypeProperties withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        this.allowHostnameCNMismatch = allowHostnameCNMismatch;
        return this;
    }

    public Object allowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public SparkLinkedServiceTypeProperties withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SparkLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model SparkLinkedServiceTypeProperties"));
        }
        if (this.port() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property port in model SparkLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model SparkLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeUntypedField("port", this.port);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeStringField("serverType", this.serverType == null ? null : this.serverType.toString());
        jsonWriter.writeStringField("thriftTransportProtocol", this.thriftTransportProtocol == null ? null : this.thriftTransportProtocol.toString());
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeUntypedField("httpPath", this.httpPath);
        jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
        jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
        jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
        jsonWriter.writeUntypedField("allowHostNameCNMismatch", this.allowHostnameCNMismatch);
        jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SparkLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SparkLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SparkLinkedServiceTypeProperties deserializedSparkLinkedServiceTypeProperties = new SparkLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.authenticationType = SparkAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("serverType".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.serverType = SparkServerType.fromString(reader.getString());
                    continue;
                }
                if ("thriftTransportProtocol".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.thriftTransportProtocol = SparkThriftTransportProtocol.fromString(reader.getString());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("httpPath".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.httpPath = reader.readUntyped();
                    continue;
                }
                if ("enableSsl".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.enableSsl = reader.readUntyped();
                    continue;
                }
                if ("trustedCertPath".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.trustedCertPath = reader.readUntyped();
                    continue;
                }
                if ("useSystemTrustStore".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.useSystemTrustStore = reader.readUntyped();
                    continue;
                }
                if ("allowHostNameCNMismatch".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.allowHostnameCNMismatch = reader.readUntyped();
                    continue;
                }
                if ("allowSelfSignedServerCert".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.allowSelfSignedServerCert = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSparkLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSparkLinkedServiceTypeProperties;
        });
    }
}

