/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SftpAuthenticationType;
import java.io.IOException;

public final class SftpServerLinkedServiceTypeProperties
implements JsonSerializable<SftpServerLinkedServiceTypeProperties> {
    private Object host;
    private Object port;
    private SftpAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private String encryptedCredential;
    private Object privateKeyPath;
    private SecretBase privateKeyContent;
    private SecretBase passPhrase;
    private Object skipHostKeyValidation;
    private Object hostKeyFingerprint;
    private static final ClientLogger LOGGER = new ClientLogger(SftpServerLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public SftpServerLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public SftpServerLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public SftpAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public SftpServerLinkedServiceTypeProperties withAuthenticationType(SftpAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public SftpServerLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public SftpServerLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SftpServerLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object privateKeyPath() {
        return this.privateKeyPath;
    }

    public SftpServerLinkedServiceTypeProperties withPrivateKeyPath(Object privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    public SecretBase privateKeyContent() {
        return this.privateKeyContent;
    }

    public SftpServerLinkedServiceTypeProperties withPrivateKeyContent(SecretBase privateKeyContent) {
        this.privateKeyContent = privateKeyContent;
        return this;
    }

    public SecretBase passPhrase() {
        return this.passPhrase;
    }

    public SftpServerLinkedServiceTypeProperties withPassPhrase(SecretBase passPhrase) {
        this.passPhrase = passPhrase;
        return this;
    }

    public Object skipHostKeyValidation() {
        return this.skipHostKeyValidation;
    }

    public SftpServerLinkedServiceTypeProperties withSkipHostKeyValidation(Object skipHostKeyValidation) {
        this.skipHostKeyValidation = skipHostKeyValidation;
        return this;
    }

    public Object hostKeyFingerprint() {
        return this.hostKeyFingerprint;
    }

    public SftpServerLinkedServiceTypeProperties withHostKeyFingerprint(Object hostKeyFingerprint) {
        this.hostKeyFingerprint = hostKeyFingerprint;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model SftpServerLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.privateKeyContent() != null) {
            this.privateKeyContent().validate();
        }
        if (this.passPhrase() != null) {
            this.passPhrase().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeUntypedField("port", this.port);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeUntypedField("privateKeyPath", this.privateKeyPath);
        jsonWriter.writeJsonField("privateKeyContent", (JsonSerializable)this.privateKeyContent);
        jsonWriter.writeJsonField("passPhrase", (JsonSerializable)this.passPhrase);
        jsonWriter.writeUntypedField("skipHostKeyValidation", this.skipHostKeyValidation);
        jsonWriter.writeUntypedField("hostKeyFingerprint", this.hostKeyFingerprint);
        return jsonWriter.writeEndObject();
    }

    public static SftpServerLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SftpServerLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SftpServerLinkedServiceTypeProperties deserializedSftpServerLinkedServiceTypeProperties = new SftpServerLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.authenticationType = SftpAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("privateKeyPath".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.privateKeyPath = reader.readUntyped();
                    continue;
                }
                if ("privateKeyContent".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.privateKeyContent = SecretBase.fromJson(reader);
                    continue;
                }
                if ("passPhrase".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.passPhrase = SecretBase.fromJson(reader);
                    continue;
                }
                if ("skipHostKeyValidation".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.skipHostKeyValidation = reader.readUntyped();
                    continue;
                }
                if ("hostKeyFingerprint".equals(fieldName)) {
                    deserializedSftpServerLinkedServiceTypeProperties.hostKeyFingerprint = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSftpServerLinkedServiceTypeProperties;
        });
    }
}

