/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SapHanaAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class SapHanaLinkedServiceProperties
implements JsonSerializable<SapHanaLinkedServiceProperties> {
    private Object connectionString;
    private Object server;
    private SapHanaAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private String encryptedCredential;

    public Object connectionString() {
        return this.connectionString;
    }

    public SapHanaLinkedServiceProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object server() {
        return this.server;
    }

    public SapHanaLinkedServiceProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public SapHanaAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public SapHanaLinkedServiceProperties withAuthenticationType(SapHanaAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public SapHanaLinkedServiceProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public SapHanaLinkedServiceProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SapHanaLinkedServiceProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeUntypedField("server", this.server);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SapHanaLinkedServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SapHanaLinkedServiceProperties)jsonReader.readObject(reader -> {
            SapHanaLinkedServiceProperties deserializedSapHanaLinkedServiceProperties = new SapHanaLinkedServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedSapHanaLinkedServiceProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedSapHanaLinkedServiceProperties.server = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedSapHanaLinkedServiceProperties.authenticationType = SapHanaAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedSapHanaLinkedServiceProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSapHanaLinkedServiceProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSapHanaLinkedServiceProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapHanaLinkedServiceProperties;
        });
    }
}

