/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;

public final class JsonDatasetTypeProperties
implements JsonSerializable<JsonDatasetTypeProperties> {
    private DatasetLocation location;
    private Object encodingName;
    private DatasetCompression compression;
    private static final ClientLogger LOGGER = new ClientLogger(JsonDatasetTypeProperties.class);

    public DatasetLocation location() {
        return this.location;
    }

    public JsonDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public Object encodingName() {
        return this.encodingName;
    }

    public JsonDatasetTypeProperties withEncodingName(Object encodingName) {
        this.encodingName = encodingName;
        return this;
    }

    public DatasetCompression compression() {
        return this.compression;
    }

    public JsonDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model JsonDatasetTypeProperties"));
        }
        this.location().validate();
        if (this.compression() != null) {
            this.compression().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        jsonWriter.writeUntypedField("encodingName", this.encodingName);
        jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
        return jsonWriter.writeEndObject();
    }

    public static JsonDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JsonDatasetTypeProperties)jsonReader.readObject(reader -> {
            JsonDatasetTypeProperties deserializedJsonDatasetTypeProperties = new JsonDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedJsonDatasetTypeProperties.location = DatasetLocation.fromJson(reader);
                    continue;
                }
                if ("encodingName".equals(fieldName)) {
                    deserializedJsonDatasetTypeProperties.encodingName = reader.readUntyped();
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    deserializedJsonDatasetTypeProperties.compression = DatasetCompression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJsonDatasetTypeProperties;
        });
    }
}

