/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeStatus;
import java.io.IOException;

public final class IntegrationRuntimeStatusResponseInner
implements JsonSerializable<IntegrationRuntimeStatusResponseInner> {
    private String name;
    private IntegrationRuntimeStatus properties;
    private static final ClientLogger LOGGER = new ClientLogger(IntegrationRuntimeStatusResponseInner.class);

    public String name() {
        return this.name;
    }

    public IntegrationRuntimeStatus properties() {
        return this.properties;
    }

    public IntegrationRuntimeStatusResponseInner withProperties(IntegrationRuntimeStatus properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model IntegrationRuntimeStatusResponseInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeStatusResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeStatusResponseInner)jsonReader.readObject(reader -> {
            IntegrationRuntimeStatusResponseInner deserializedIntegrationRuntimeStatusResponseInner = new IntegrationRuntimeStatusResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedIntegrationRuntimeStatusResponseInner.properties = IntegrationRuntimeStatus.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIntegrationRuntimeStatusResponseInner.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIntegrationRuntimeStatusResponseInner;
        });
    }
}

