/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.HttpAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class HttpLinkedServiceTypeProperties
implements JsonSerializable<HttpLinkedServiceTypeProperties> {
    private Object url;
    private HttpAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object authHeaders;
    private Object embeddedCertData;
    private Object certThumbprint;
    private String encryptedCredential;
    private Object enableServerCertificateValidation;
    private static final ClientLogger LOGGER = new ClientLogger(HttpLinkedServiceTypeProperties.class);

    public Object url() {
        return this.url;
    }

    public HttpLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public HttpAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public HttpLinkedServiceTypeProperties withAuthenticationType(HttpAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public HttpLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public HttpLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object authHeaders() {
        return this.authHeaders;
    }

    public HttpLinkedServiceTypeProperties withAuthHeaders(Object authHeaders) {
        this.authHeaders = authHeaders;
        return this;
    }

    public Object embeddedCertData() {
        return this.embeddedCertData;
    }

    public HttpLinkedServiceTypeProperties withEmbeddedCertData(Object embeddedCertData) {
        this.embeddedCertData = embeddedCertData;
        return this;
    }

    public Object certThumbprint() {
        return this.certThumbprint;
    }

    public HttpLinkedServiceTypeProperties withCertThumbprint(Object certThumbprint) {
        this.certThumbprint = certThumbprint;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public HttpLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object enableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public HttpLinkedServiceTypeProperties withEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model HttpLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeUntypedField("authHeaders", this.authHeaders);
        jsonWriter.writeUntypedField("embeddedCertData", this.embeddedCertData);
        jsonWriter.writeUntypedField("certThumbprint", this.certThumbprint);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
        return jsonWriter.writeEndObject();
    }

    public static HttpLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HttpLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            HttpLinkedServiceTypeProperties deserializedHttpLinkedServiceTypeProperties = new HttpLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedHttpLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedHttpLinkedServiceTypeProperties.authenticationType = HttpAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedHttpLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedHttpLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authHeaders".equals(fieldName)) {
                    deserializedHttpLinkedServiceTypeProperties.authHeaders = reader.readUntyped();
                    continue;
                }
                if ("embeddedCertData".equals(fieldName)) {
                    deserializedHttpLinkedServiceTypeProperties.embeddedCertData = reader.readUntyped();
                    continue;
                }
                if ("certThumbprint".equals(fieldName)) {
                    deserializedHttpLinkedServiceTypeProperties.certThumbprint = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedHttpLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("enableServerCertificateValidation".equals(fieldName)) {
                    deserializedHttpLinkedServiceTypeProperties.enableServerCertificateValidation = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpLinkedServiceTypeProperties;
        });
    }
}

