/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class HDInsightHiveActivityTypeProperties
implements JsonSerializable<HDInsightHiveActivityTypeProperties> {
    private List<LinkedServiceReference> storageLinkedServices;
    private List<Object> arguments;
    private HDInsightActivityDebugInfoOption getDebugInfo;
    private Object scriptPath;
    private LinkedServiceReference scriptLinkedService;
    private Map<String, Object> defines;
    private Map<String, Object> variables;
    private Integer queryTimeout;

    public List<LinkedServiceReference> storageLinkedServices() {
        return this.storageLinkedServices;
    }

    public HDInsightHiveActivityTypeProperties withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    public List<Object> arguments() {
        return this.arguments;
    }

    public HDInsightHiveActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightHiveActivityTypeProperties withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public Object scriptPath() {
        return this.scriptPath;
    }

    public HDInsightHiveActivityTypeProperties withScriptPath(Object scriptPath) {
        this.scriptPath = scriptPath;
        return this;
    }

    public LinkedServiceReference scriptLinkedService() {
        return this.scriptLinkedService;
    }

    public HDInsightHiveActivityTypeProperties withScriptLinkedService(LinkedServiceReference scriptLinkedService) {
        this.scriptLinkedService = scriptLinkedService;
        return this;
    }

    public Map<String, Object> defines() {
        return this.defines;
    }

    public HDInsightHiveActivityTypeProperties withDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    public Map<String, Object> variables() {
        return this.variables;
    }

    public HDInsightHiveActivityTypeProperties withVariables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public Integer queryTimeout() {
        return this.queryTimeout;
    }

    public HDInsightHiveActivityTypeProperties withQueryTimeout(Integer queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public void validate() {
        if (this.storageLinkedServices() != null) {
            this.storageLinkedServices().forEach(e -> e.validate());
        }
        if (this.scriptLinkedService() != null) {
            this.scriptLinkedService().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("storageLinkedServices", this.storageLinkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("getDebugInfo", this.getDebugInfo == null ? null : this.getDebugInfo.toString());
        jsonWriter.writeUntypedField("scriptPath", this.scriptPath);
        jsonWriter.writeJsonField("scriptLinkedService", (JsonSerializable)this.scriptLinkedService);
        jsonWriter.writeMapField("defines", this.defines, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("variables", this.variables, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeNumberField("queryTimeout", (Number)this.queryTimeout);
        return jsonWriter.writeEndObject();
    }

    public static HDInsightHiveActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightHiveActivityTypeProperties)jsonReader.readObject(reader -> {
            HDInsightHiveActivityTypeProperties deserializedHDInsightHiveActivityTypeProperties = new HDInsightHiveActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageLinkedServices".equals(fieldName)) {
                    List storageLinkedServices;
                    deserializedHDInsightHiveActivityTypeProperties.storageLinkedServices = storageLinkedServices = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    List arguments;
                    deserializedHDInsightHiveActivityTypeProperties.arguments = arguments = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("getDebugInfo".equals(fieldName)) {
                    deserializedHDInsightHiveActivityTypeProperties.getDebugInfo = HDInsightActivityDebugInfoOption.fromString(reader.getString());
                    continue;
                }
                if ("scriptPath".equals(fieldName)) {
                    deserializedHDInsightHiveActivityTypeProperties.scriptPath = reader.readUntyped();
                    continue;
                }
                if ("scriptLinkedService".equals(fieldName)) {
                    deserializedHDInsightHiveActivityTypeProperties.scriptLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("defines".equals(fieldName)) {
                    Map defines;
                    deserializedHDInsightHiveActivityTypeProperties.defines = defines = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("variables".equals(fieldName)) {
                    Map variables;
                    deserializedHDInsightHiveActivityTypeProperties.variables = variables = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedHDInsightHiveActivityTypeProperties.queryTimeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHDInsightHiveActivityTypeProperties;
        });
    }
}

