/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlowSink;
import com.azure.resourcemanager.datafactory.models.DataFlowSource;
import com.azure.resourcemanager.datafactory.models.Transformation;
import java.io.IOException;
import java.util.List;

public final class FlowletTypeProperties
implements JsonSerializable<FlowletTypeProperties> {
    private List<DataFlowSource> sources;
    private List<DataFlowSink> sinks;
    private List<Transformation> transformations;
    private String script;
    private List<String> scriptLines;

    public List<DataFlowSource> sources() {
        return this.sources;
    }

    public FlowletTypeProperties withSources(List<DataFlowSource> sources) {
        this.sources = sources;
        return this;
    }

    public List<DataFlowSink> sinks() {
        return this.sinks;
    }

    public FlowletTypeProperties withSinks(List<DataFlowSink> sinks) {
        this.sinks = sinks;
        return this;
    }

    public List<Transformation> transformations() {
        return this.transformations;
    }

    public FlowletTypeProperties withTransformations(List<Transformation> transformations) {
        this.transformations = transformations;
        return this;
    }

    public String script() {
        return this.script;
    }

    public FlowletTypeProperties withScript(String script) {
        this.script = script;
        return this;
    }

    public List<String> scriptLines() {
        return this.scriptLines;
    }

    public FlowletTypeProperties withScriptLines(List<String> scriptLines) {
        this.scriptLines = scriptLines;
        return this;
    }

    public void validate() {
        if (this.sources() != null) {
            this.sources().forEach(e -> e.validate());
        }
        if (this.sinks() != null) {
            this.sinks().forEach(e -> e.validate());
        }
        if (this.transformations() != null) {
            this.transformations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("sources", this.sources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sinks", this.sinks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("transformations", this.transformations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("script", this.script);
        jsonWriter.writeArrayField("scriptLines", this.scriptLines, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static FlowletTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FlowletTypeProperties)jsonReader.readObject(reader -> {
            FlowletTypeProperties deserializedFlowletTypeProperties = new FlowletTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sources".equals(fieldName)) {
                    List sources;
                    deserializedFlowletTypeProperties.sources = sources = reader.readArray(reader1 -> DataFlowSource.fromJson(reader1));
                    continue;
                }
                if ("sinks".equals(fieldName)) {
                    List sinks;
                    deserializedFlowletTypeProperties.sinks = sinks = reader.readArray(reader1 -> DataFlowSink.fromJson(reader1));
                    continue;
                }
                if ("transformations".equals(fieldName)) {
                    List transformations;
                    deserializedFlowletTypeProperties.transformations = transformations = reader.readArray(reader1 -> Transformation.fromJson(reader1));
                    continue;
                }
                if ("script".equals(fieldName)) {
                    deserializedFlowletTypeProperties.script = reader.getString();
                    continue;
                }
                if ("scriptLines".equals(fieldName)) {
                    List scriptLines;
                    deserializedFlowletTypeProperties.scriptLines = scriptLines = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlowletTypeProperties;
        });
    }
}

